/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.adkeeper.impl;

import com.bxm.app.model.ro.ProviderAppAdRo;
import com.bxm.app.model.vo.QueryPositionIdAndNameVo;
import com.bxm.dao.adkeeper.AdPositionMapper;
import com.bxm.dao.adkeeper.AdRulesMapper;
import com.bxm.dao.adkeeper.ext.AdPositionMapperExt;
import com.bxm.report.facade.app.AppEntranceFacadeIntegration;
import com.bxm.report.facade.app.ProviderAppFacadeIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dto.adposition.AdpositionDto;
import com.bxm.report.model.dto.provideapp.ProvideAppDto;
import com.bxm.report.model.enums.RuleTargetEnum;
import com.bxm.report.model.enums.RuleTypeEnum;
import com.bxm.report.model.utils.DataParkUtils;
import com.bxm.report.model.vo.adposition.AdpositionVo;
import com.bxm.report.model.vo.adposition.QueryMediaNameVo;
import com.bxm.report.model.vo.appcount.AppCountVo;
import com.bxm.report.service.adkeeper.AdPositionService;
import com.bxm.report.service.utils.ListUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdPositionServiceImpl
implements AdPositionService {
    private static final int TWO = 2;
    @Autowired
    private AdPositionMapper adPositionMapper;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private AdPositionMapperExt adPositionMapperExt;
    @Autowired
    private AppEntranceFacadeIntegration appEntranceFacadeIntegration;
    @Autowired
    private ProviderAppFacadeIntegration providerAppFacadeIntegration;

    @Override
    public Pagination findAll(AdpositionDto condition) {
        String result;
        if (condition == null) {
            condition = new AdpositionDto();
        }
        Integer totalcount = this.adPositionMapper.totalcount(condition);
        List<Object> objectList = new ArrayList(totalcount);
        if (null != condition.getAdTicketId() && StringUtil.isNotBlank((CharSequence)(result = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()), condition.getAdTicketId())))) {
            result = result.substring(2);
            String[] resultArray = result.split(",");
            ArrayList<String> appkeyList = new ArrayList<String>(resultArray.length);
            for (String s : resultArray) {
                appkeyList.add(s);
            }
            List adpositionVos = this.adPositionMapper.findAllByAppkey(appkeyList, condition);
            List adpositionVoList = this.adPositionMapper.findAllExcludeAppkey(adpositionVos, condition);
            adpositionVos.addAll(adpositionVoList);
            objectList = ListUtil.getTotalPage(adpositionVos, adpositionVos.size(), condition.getPageNum(), condition.getPageSize());
        }
        Pagination pagination = new Pagination();
        pagination.setList(objectList);
        if (CollectionUtils.isEmpty(objectList)) {
            List list = this.adPositionMapper.findAll(condition);
            pagination.setList(list);
        }
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        pagination.setTotalCount(totalcount.intValue());
        return pagination;
    }

    @Override
    public Pagination findByAdTicketId(AdpositionDto condition) {
        String result;
        if (condition == null || null == condition.getAdTicketId()) {
            throw new ValidateException("adTicketId is null");
        }
        Integer totalcount = this.adPositionMapper.totalcount(condition);
        List<Object> objectList = new ArrayList(totalcount);
        if (null != condition.getAdTicketId() && StringUtil.isNotBlank((CharSequence)(result = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()), condition.getAdTicketId())))) {
            result = result.substring(2);
            String[] resultArray = result.split(",");
            ArrayList<String> appkeyList = new ArrayList<String>(resultArray.length);
            for (String s : resultArray) {
                appkeyList.add(s);
            }
            List adpositionVos = this.adPositionMapper.findAllByAppkey(appkeyList, condition);
            objectList = ListUtil.getTotalPage(adpositionVos, adpositionVos.size(), condition.getPageNum(), condition.getPageSize());
        }
        Pagination pagination = new Pagination();
        pagination.setList(objectList);
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        pagination.setTotalCount(totalcount.intValue());
        return pagination;
    }

    @Override
    public Pagination findByIdsStr(AdpositionDto condition) {
        Pagination pagination = new Pagination();
        List<Object> objectList = new ArrayList();
        if (StringUtil.isNotBlank((CharSequence)condition.getIdsStr())) {
            String[] resultArray = condition.getIdsStr().split(",");
            ArrayList<String> appkeyList = new ArrayList<String>(resultArray.length);
            for (String s : resultArray) {
                appkeyList.add(s);
            }
            List adpositionVos = this.adPositionMapper.findAllByAppkey(appkeyList, condition);
            objectList = ListUtil.getTotalPage(adpositionVos, adpositionVos.size(), condition.getPageNum(), condition.getPageSize());
            pagination.setTotalCount(resultArray.length);
        }
        pagination.setList(objectList);
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        return pagination;
    }

    @Override
    public List<ProvideAppDto> findAllByAppName(String appName) {
        List list = this.adPositionMapper.findAllByAppName(appName);
        return list;
    }

    @Override
    public List<ProvideAppDto> findAllByPositionId(String positonId) {
        ArrayList<String> position = new ArrayList<String>();
        for (String positionId : positonId.split(",")) {
            position.add(positionId);
        }
        List list = this.adPositionMapper.findAllByPositionId(position);
        return list;
    }

    @Override
    public List<AdpositionVo> findBusinesses(String appKey, String keyword, String onlineStart, String onlineEnd) {
        HashMap map = Maps.newHashMap();
        map.put("appKey", appKey);
        map.put("businessName", keyword);
        map.put("onlineStart", onlineStart);
        map.put("onlineEnd", onlineEnd);
        List businesses = this.adPositionMapperExt.findBusinesses((Map)map);
        if (CollectionUtils.isNotEmpty((Collection)businesses)) {
            return businesses;
        }
        return new ArrayList<AdpositionVo>();
    }

    @Override
    public List<AdpositionVo> findAllBusinesses() {
        HashMap map = new HashMap();
        List allBusinesses = this.adPositionMapperExt.findAllBusinesses(map);
        if (CollectionUtils.isEmpty((Collection)allBusinesses)) {
            return new ArrayList<AdpositionVo>();
        }
        return allBusinesses;
    }

    @Override
    public Map<String, Integer> getBusinessNumberByAppKeys(List<String> appKeys) {
        List businessNumberByAppKeys = this.adPositionMapperExt.getBusinessNumberByAppKeys(appKeys);
        HashMap maps = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)businessNumberByAppKeys)) {
            for (AppCountVo appBusinessVo : businessNumberByAppKeys) {
                maps.put(appBusinessVo.getAppKey(), appBusinessVo.getBusinessCount());
            }
        }
        return maps;
    }

    @Override
    public Map<String, String> findAppKeysByOnline(List<String> list, String onlineStart, String onlineEndTemp) {
        List appCountVos;
        HashMap<String, String> appCountMap = new HashMap<String, String>();
        String onlineEnd = "";
        if (onlineEndTemp != null && onlineEndTemp != "") {
            onlineEnd = DataParkUtils.getNextDate((String)onlineEndTemp);
        }
        if ((appCountVos = this.adPositionMapperExt.AppKeysByOnline(onlineStart, onlineEnd, list)).size() == 0 || appCountVos == null) {
            return new HashMap<String, String>();
        }
        appCountVos.forEach(appCountVo -> appCountMap.put(appCountVo.getAppKey(), appCountVo.getOnlineTime()));
        return appCountMap;
    }

    @Override
    public List<AppCountVo> findBusinessByAppkeyTime(String appKey, String onlineStart, String onlineEndTemp) {
        HashMap<String, String> map = new HashMap<String, String>();
        String onlineEnd = "";
        map.put("onlineStart", onlineStart);
        if (onlineEndTemp != null && onlineEndTemp != "") {
            onlineEnd = DataParkUtils.getNextDate((String)onlineEndTemp);
        }
        map.put("onlineEnd", onlineEnd);
        map.put("appKey", appKey);
        return this.adPositionMapperExt.findBusinessByAppkeyTime(map);
    }

    @Override
    public List<AdpositionVo> findByBusinesses(String appKey, StringBuffer sbBusinesses) {
        ArrayList<String> businesses = new ArrayList<String>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        if (sbBusinesses != null && StringUtils.isNotEmpty((String)sbBusinesses.toString())) {
            for (String business : sbBusinesses.toString().split(",")) {
                try {
                    businesses.add(business.replaceAll("ad-", ""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            paramsMap.put("businesss", businesses);
        }
        paramsMap.put("appKey", appKey);
        if (businesses.size() == 0) {
            return new ArrayList<AdpositionVo>();
        }
        if (StringUtils.isEmpty((String)appKey)) {
            return new ArrayList<AdpositionVo>();
        }
        List allBusinesses = this.adPositionMapperExt.findAllBusinesses(paramsMap);
        if (CollectionUtils.isEmpty((Collection)allBusinesses)) {
            return new ArrayList<AdpositionVo>();
        }
        return allBusinesses;
    }

    @Override
    public List<QueryMediaNameVo> queryMediaIdOrNameByKeywords(String keyWords) {
        if (StringUtils.isBlank((String)keyWords)) {
            return Collections.emptyList();
        }
        List providerAppAdRos = this.providerAppFacadeIntegration.getListByAppNameOrAppkey(keyWords);
        if (CollectionUtils.isEmpty((Collection)providerAppAdRos)) {
            return Collections.emptyList();
        }
        ArrayList<QueryMediaNameVo> list = new ArrayList<QueryMediaNameVo>(providerAppAdRos.size());
        for (ProviderAppAdRo providerAppAdRo : providerAppAdRos) {
            QueryMediaNameVo queryMediaNameVo = new QueryMediaNameVo();
            queryMediaNameVo.setAppKey(providerAppAdRo.getAppKey());
            queryMediaNameVo.setAppName(providerAppAdRo.getAppName());
            list.add(queryMediaNameVo);
        }
        return list;
    }

    @Override
    public List<QueryPositionIdAndNameVo> queryPositionIdOrNameByKeywords(String keyWords, String appKey) {
        if (StringUtils.isBlank((String)keyWords) && StringUtils.isBlank((String)appKey)) {
            return Collections.emptyList();
        }
        return this.appEntranceFacadeIntegration.getPositionIdAndName(keyWords, appKey);
    }
}

