/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.adkeeper.impl;

import com.bxm.dao.dictionary.DictionariesMapper;
import com.bxm.report.model.common.Dictionaries;
import com.bxm.report.model.constant.RedisKeys;
import com.bxm.report.service.adkeeper.DictionariesService;
import com.bxm.util.dto.ValidateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class DictionariesServiceImpl
implements DictionariesService {
    @Autowired
    private DictionariesMapper dictionariesMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public List<Dictionaries> findAll(String typegroupid) {
        if (typegroupid == null) {
            throw new ValidateException("typegroupid must be not null");
        }
        return this.dictionariesMapper.findAll(typegroupid);
    }

    @Override
    public Dictionaries findByCode(String code, String groupTypeCode) {
        if (code == null) {
            throw new ValidateException("typecode must be not null");
        }
        return this.dictionariesMapper.findByCode(code, groupTypeCode);
    }

    @Override
    public String findNameByCode(String code, String groupTypeCode) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)groupTypeCode)) {
            return null;
        }
        String name = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKeys.getKey((String)"DICTIONAY:%s:%s", (Object[])new Object[]{groupTypeCode, code}));
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return name;
        }
        name = this.dictionariesMapper.findNameByCode(code, groupTypeCode);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            this.stringRedisTemplate.opsForValue().set((Object)RedisKeys.getKey((String)"DICTIONAY:%s:%s", (Object[])new Object[]{groupTypeCode, code}), (Object)name, 5L, TimeUnit.MINUTES);
        }
        return name;
    }

    @Override
    public Map<String, String> getCodeDetailMapByCode(String code) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        List<Dictionaries> results = this.findAll(code);
        for (Dictionaries dictionaries : results) {
            resultMap.put(dictionaries.getTypecode(), dictionaries.getTypename());
        }
        return resultMap;
    }
}

