/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.adkeeper.impl;

import com.bxm.dao.adkeeper.AdTicketMapper;
import com.bxm.report.model.dao.adticket.AdTicket;
import com.bxm.report.model.dto.advertiser.AdvertiserDto;
import com.bxm.report.service.adkeeper.InfoActivityCertificateService;
import com.bxm.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InfoActivityCertificateServiceImpl
implements InfoActivityCertificateService {
    @Autowired
    private AdTicketMapper adTicketMapper;

    @Override
    public List<AdTicket> findCertificateByKeyword(String keyword) {
        HashMap<String, String> maps = new HashMap<String, String>(16);
        maps.put("keyword", keyword);
        List certificateByKeyword = this.adTicketMapper.findCertificateByKeywords(maps);
        if (CollectionUtils.isEmpty((Collection)certificateByKeyword)) {
            return new ArrayList<AdTicket>();
        }
        return certificateByKeyword;
    }

    @Override
    public List<AdTicket> findCertificateInfoByCertificates(StringBuffer ids) {
        ArrayList<Long> certificates = new ArrayList<Long>();
        HashMap<String, ArrayList<Long>> paramsMap = new HashMap<String, ArrayList<Long>>(16);
        if (ids != null && StringUtils.isNotEmpty((CharSequence)ids)) {
            for (String id : ids.toString().split(",")) {
                try {
                    certificates.add(Long.valueOf(id));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            paramsMap.put("certificates", certificates);
        }
        if (certificates.size() == 0) {
            return null;
        }
        List certificateInfos = this.adTicketMapper.findCertificateInfoByCertificates(paramsMap);
        if (CollectionUtils.isEmpty((Collection)certificateInfos)) {
            return new ArrayList<AdTicket>();
        }
        return certificateInfos;
    }

    @Override
    public List<AdTicket> findCertificateByParams(String keyword, List<AdvertiserDto> advertiserList, Integer ticketType) {
        List certificateByKeyword;
        HashMap<String, Object> maps = new HashMap<String, Object>(16);
        maps.put("keyword", keyword);
        maps.put("ticketType", ticketType);
        if (CollectionUtils.isNotEmpty(advertiserList)) {
            maps.put("advertiserList", advertiserList);
        }
        if (CollectionUtils.isEmpty((Collection)(certificateByKeyword = this.adTicketMapper.findCertificateByKeywords(maps)))) {
            return new ArrayList<AdTicket>();
        }
        return certificateByKeyword;
    }

    @Override
    public List<AdTicket> findCertificateByParamsAndAe(String keyword, List<AdvertiserDto> advertiserList, Integer ticketType, String ae) {
        List certificateByKeyword;
        HashMap<String, Object> maps = new HashMap<String, Object>(16);
        maps.put("keyword", keyword);
        if (ticketType != null) {
            maps.put("ticketType", ticketType);
        }
        if (CollectionUtils.isNotEmpty(advertiserList)) {
            maps.put("advertiserList", advertiserList);
        }
        if (StringUtil.isNotBlank((CharSequence)ae)) {
            maps.put("ae", ae);
        }
        if (CollectionUtils.isEmpty((Collection)(certificateByKeyword = this.adTicketMapper.findCertificateByKeywords(maps)))) {
            return new ArrayList<AdTicket>();
        }
        return certificateByKeyword;
    }

    @Override
    public List<AdTicket> findCertificateByAdvertiser(List<Long> list) {
        List result = this.adTicketMapper.findTicketByAdvertiser(list);
        return CollectionUtils.isEmpty((Collection)result) ? new ArrayList() : result;
    }
}

