/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.datapark.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.dao.adkeeper.TblActivityMapper;
import com.bxm.dao.adkeeper.ext.AdPositionMapperExt;
import com.bxm.dao.adkeeper.ext.InfoAppMsgMapperExt;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.activity.ActivityReportVo;
import com.bxm.report.facade.datapark.DataparkActivityPullerIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.common.Dictionaries;
import com.bxm.report.model.dao.activity.ActivityCount;
import com.bxm.report.model.dao.activity.ActivityWithBLOBs;
import com.bxm.report.model.dao.app.InfoAppMsg;
import com.bxm.report.model.dto.activity.InfoActivityMsgDto;
import com.bxm.report.model.ro.ActivityReportRo;
import com.bxm.report.model.vo.activity.ActivityAppBusinessVo;
import com.bxm.report.model.vo.activity.ActivityAppVo;
import com.bxm.report.model.vo.activity.ActivityBusinessDate;
import com.bxm.report.model.vo.activity.ActivityDailyReportVo;
import com.bxm.report.model.vo.activity.ActivityDate;
import com.bxm.report.model.vo.activity.NewActivityReportVo;
import com.bxm.report.model.vo.adposition.AdpositionVo;
import com.bxm.report.model.vo.app.AppBusinessActivityDateVo;
import com.bxm.report.service.adkeeper.DictionariesService;
import com.bxm.report.service.datapark.DataparkActivityService;
import com.bxm.report.service.utils.ExcelUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataparkActivityServiceImpl
implements DataparkActivityService {
    @Autowired
    private TblActivityMapper activityMapper;
    @Autowired
    private InfoAppMsgMapperExt infoAppMsgMapperExt;
    @Autowired
    private AdPositionMapperExt adPositionMapperExt;
    @Autowired
    private DictionariesService dictionariesService;
    @Resource
    private DataparkActivityPullerIntegration dataparkActivityPullerIntegration;

    @Override
    public ResultModel pullNewActivityData(ResultModel<Page> resultModel) {
        if (resultModel.getReturnValue() == null) {
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)new Page());
            return rs;
        }
        Page pagination = (Page)resultModel.getReturnValue();
        List activityReportVos = pagination.getList();
        if (activityReportVos.isEmpty()) {
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)new Page());
            return rs;
        }
        Map<String, String> map = this.dictionariesService.getCodeDetailMapByCode("acttag");
        for (ActivityReportVo activityReportVo : activityReportVos) {
            if (!StringUtil.isNotBlank((CharSequence)activityReportVo.getActivityTag())) continue;
            String s = "";
            String[] split = activityReportVo.getActivityTag().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (!StringUtil.isNotBlank((CharSequence)map.get(split[i]))) continue;
                s = s + map.get(split[i]) + ",";
            }
            if (!StringUtils.isNotBlank((String)s)) continue;
            activityReportVo.setActivityTagShow(s.substring(0, s.length() - 1));
        }
        pagination.setList(activityReportVos);
        resultModel.setReturnValue((Object)pagination);
        return resultModel;
    }

    @Override
    public void newActivityReportExport(List<ActivityReportVo> activityReportVos, HttpServletResponse response) {
        ArrayList<NewActivityReportVo> newActivityReportVos = new ArrayList<NewActivityReportVo>();
        for (ActivityReportVo activityReportVo : activityReportVos) {
            NewActivityReportVo newActivityReportVo = new NewActivityReportVo();
            BeanUtils.copyProperties((Object)activityReportVo, (Object)newActivityReportVo);
            newActivityReportVos.add(newActivityReportVo);
        }
        ExcelUtil.exportExcel(newActivityReportVos, null, null, NewActivityReportVo.class, "\u6d3b\u52a8\u62a5\u8868.xls", response);
    }

    @Override
    public ResultModel<Pagination> pullActivityData(ResultModel<Pagination> resultModel) {
        if (resultModel.getReturnValue() == null) {
            return new ResultModel();
        }
        Pagination pagination = (Pagination)resultModel.getReturnValue();
        List activityCounts = pagination.getList();
        if (activityCounts.isEmpty()) {
            return new ResultModel();
        }
        HashMap<Long, ActivityWithBLOBs> activityWithBLOBsMap = new HashMap<Long, ActivityWithBLOBs>();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ActivityCount activityCount : activityCounts) {
            if (activityCount.getActivityId() == null) continue;
            ids.add(activityCount.getActivityId());
        }
        HashMap<String, ArrayList<Long>> idsMap = new HashMap<String, ArrayList<Long>>();
        if (ids.size() > 0) {
            idsMap.put("ids", ids);
        }
        List activityWithBLOBsList = Lists.newArrayList();
        if (!idsMap.isEmpty()) {
            activityWithBLOBsList = this.activityMapper.findList(idsMap);
        }
        for (ActivityWithBLOBs activityWithBLOBs : activityWithBLOBsList) {
            activityWithBLOBsMap.put(activityWithBLOBs.getId(), activityWithBLOBs);
        }
        ArrayList<ActivityDailyReportVo> activityVos = new ArrayList<ActivityDailyReportVo>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityDailyReportVo activityVo = new ActivityDailyReportVo();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityVo);
            String activityName = activityWithBLOBsMap.getOrDefault(activityVo.getActivityId(), new ActivityWithBLOBs()).getActivityName();
            activityVo.setActivityName(StringUtils.isEmpty((String)activityName) ? "" : activityName);
            String activitytype = activityWithBLOBsMap.getOrDefault(activityVo.getActivityId(), new ActivityWithBLOBs()).getActivityType();
            Dictionaries dictionaries = this.dictionariesService.findByCode(StringUtils.isEmpty((String)activitytype) ? "" : activitytype, "acttype");
            if (dictionaries != null) {
                activityVo.setActivityModelName(dictionaries.getTypename());
            }
            activityVo.setPerClickPvChange(this.getPerChangeName(activityCount));
            ActivityWithBLOBs activityWithBLOB = (ActivityWithBLOBs)activityWithBLOBsMap.get(activityVo.getActivityId());
            this.setDesignerAndPlanner(activityWithBLOB, activityVo);
            activityVos.add(activityVo);
        }
        pagination.setList(activityVos);
        resultModel.setReturnValue((Object)pagination);
        return resultModel;
    }

    @Override
    public void activityReportExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        HashMap<Long, ActivityWithBLOBs> activityWithBLOBsMap = new HashMap<Long, ActivityWithBLOBs>();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ActivityCount activityCount : activityCounts) {
            if (activityCount.getActivityId() == null) continue;
            ids.add(activityCount.getActivityId());
        }
        HashMap<String, ArrayList<Long>> idsMap = new HashMap<String, ArrayList<Long>>();
        if (ids.size() > 0) {
            idsMap.put("ids", ids);
        }
        List activityWithBLOBsList = Lists.newArrayList();
        if (!idsMap.isEmpty()) {
            activityWithBLOBsList = this.activityMapper.findList(idsMap);
        }
        for (ActivityWithBLOBs activityWithBLOBs : activityWithBLOBsList) {
            activityWithBLOBsMap.put(activityWithBLOBs.getId(), activityWithBLOBs);
        }
        ArrayList<ActivityDailyReportVo> activityVos = new ArrayList<ActivityDailyReportVo>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityDailyReportVo activityVo = new ActivityDailyReportVo();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityVo);
            String activityName = activityWithBLOBsMap.getOrDefault(activityVo.getActivityId(), new ActivityWithBLOBs()).getActivityName();
            activityVo.setActivityName(StringUtils.isEmpty((String)activityName) ? "" : activityName);
            String activityType = activityWithBLOBsMap.getOrDefault(activityVo.getActivityId(), new ActivityWithBLOBs()).getActivityType();
            Dictionaries dictionaries = this.dictionariesService.findByCode(StringUtils.isEmpty((String)activityType) ? "" : activityType, "acttype");
            if (dictionaries != null) {
                activityVo.setActivityModelName(dictionaries.getTypename());
            }
            ActivityWithBLOBs activityWithBLOB = (ActivityWithBLOBs)activityWithBLOBsMap.get(activityVo.getActivityId());
            this.setDesignerAndPlanner(activityWithBLOB, activityVo);
            activityVos.add(activityVo);
        }
        ExcelUtil.exportExcel(activityVos, null, null, ActivityDailyReportVo.class, "\u6d3b\u52a8\u62a5\u8868.xls", response);
    }

    @Override
    public ResultModel pullActivityAppData(ResultModel<Pagination> resultModel) {
        if (resultModel.getReturnValue() == null) {
            return new ResultModel();
        }
        Pagination pagination = (Pagination)resultModel.getReturnValue();
        List activityCounts = pagination.getList();
        if (activityCounts.isEmpty()) {
            return new ResultModel();
        }
        ArrayList<String> appKeys = new ArrayList<String>();
        for (ActivityCount activityCount : activityCounts) {
            if (StringUtils.isEmpty((String)activityCount.getAppKey())) continue;
            appKeys.add(activityCount.getAppKey());
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        if (appKeys.size() > 0) {
            map.put("appKeys", appKeys);
        }
        List infoAppMsgs = Lists.newArrayList();
        if (!map.isEmpty()) {
            infoAppMsgs = this.infoAppMsgMapperExt.findAll(map);
        }
        HashMap<String, InfoAppMsg> appMsgMap = new HashMap<String, InfoAppMsg>();
        for (InfoAppMsg infoAppMsg : infoAppMsgs) {
            appMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
        }
        ArrayList<ActivityAppVo> activityAppVos = new ArrayList<ActivityAppVo>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityAppVo activityAppVo = new ActivityAppVo();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityAppVo);
            String appName = appMsgMap.getOrDefault(activityAppVo.getAppKey(), new InfoAppMsg()).getAppname();
            activityAppVo.setAppName(StringUtils.isEmpty((String)appName) ? "" : appName);
            activityAppVo.setPerClickPv(activityCount.getPerClickPv());
            activityAppVo.setPerClickPvChange(this.getPerChangeName(activityCount));
            activityAppVos.add(activityAppVo);
        }
        pagination.setList(activityAppVos);
        resultModel.setReturnValue((Object)pagination);
        return resultModel;
    }

    @Override
    public void activityReportAppExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        ArrayList<String> appKeys = new ArrayList<String>();
        for (ActivityCount activityCount : activityCounts) {
            if (StringUtils.isEmpty((String)activityCount.getAppKey())) continue;
            appKeys.add(activityCount.getAppKey());
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        if (appKeys.size() > 0) {
            map.put("appKeys", appKeys);
        }
        List infoAppMsgs = Lists.newArrayList();
        if (!map.isEmpty()) {
            infoAppMsgs = this.infoAppMsgMapperExt.findAll(map);
        }
        HashMap<String, InfoAppMsg> appMsgMap = new HashMap<String, InfoAppMsg>();
        for (InfoAppMsg infoAppMsg : infoAppMsgs) {
            appMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
        }
        ArrayList<ActivityAppVo> activityAppVos = new ArrayList<ActivityAppVo>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityAppVo activityAppVo = new ActivityAppVo();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityAppVo);
            String appName = appMsgMap.getOrDefault(activityAppVo.getAppKey(), new InfoAppMsg()).getAppname();
            activityAppVo.setAppName(StringUtils.isEmpty((String)appName) ? "" : appName);
            activityAppVos.add(activityAppVo);
        }
        ExcelUtil.exportExcel(activityAppVos, null, null, ActivityAppVo.class, "\u6d3b\u52a8\u62a5\u8868.xls", response);
    }

    @Override
    public ResultModel pullActivityAppBusinessData(ResultModel<Pagination> resultModel) {
        if (resultModel.getReturnValue() == null) {
            return new ResultModel();
        }
        Pagination pagination = (Pagination)resultModel.getReturnValue();
        List activityCounts = pagination.getList();
        if (activityCounts.isEmpty()) {
            return new ResultModel();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> businesss = new ArrayList<String>();
        for (ActivityCount activityCount : activityCounts) {
            if (StringUtils.isEmpty((String)activityCount.getBusiness())) continue;
            if (map.get("appKey") == null || map.get("appKey").equals("")) {
                map.put("appKey", activityCount.getAppKey());
            }
            businesss.add(activityCount.getBusiness().replace("ad-", ""));
        }
        if (businesss.size() > 0) {
            map.put("businesss", businesss);
        }
        List adpositionVos = Lists.newArrayList();
        if (!map.isEmpty()) {
            adpositionVos = this.adPositionMapperExt.findAllBusinesses(map);
        }
        HashMap<String, AdpositionVo> adpositionVoMap = new HashMap<String, AdpositionVo>();
        for (AdpositionVo adpositionVo : adpositionVos) {
            adpositionVoMap.put(adpositionVo.getAppkey() + "-" + adpositionVo.getBusiness(), adpositionVo);
        }
        ArrayList<ActivityAppBusinessVo> activityAppBusinessVos = new ArrayList<ActivityAppBusinessVo>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityAppBusinessVo activityAppBusinessVo = new ActivityAppBusinessVo();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityAppBusinessVo);
            String businessName = "";
            if (!StringUtils.isEmpty((String)activityCount.getBusiness())) {
                businessName = adpositionVoMap.getOrDefault(activityCount.getAppKey() + "-" + activityCount.getBusiness().replace("ad-", ""), new AdpositionVo()).getName();
            }
            activityAppBusinessVo.setBusinessName(StringUtils.isEmpty((String)businessName) ? "" : businessName);
            activityAppBusinessVo.setPerClickPv(activityCount.getPerClickPv());
            activityAppBusinessVo.setPerClickPvChange(this.getPerChangeName(activityCount));
            activityAppBusinessVos.add(activityAppBusinessVo);
        }
        pagination.setList(activityAppBusinessVos);
        resultModel.setReturnValue((Object)pagination);
        return resultModel;
    }

    @Override
    public void activityReportAppBusinessExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> businesss = new ArrayList<String>();
        for (ActivityCount activityCount : activityCounts) {
            if (StringUtils.isEmpty((String)activityCount.getBusiness())) continue;
            if (map.get("appKey") == null || map.get("appKey").equals("")) {
                map.put("appKey", activityCount.getAppKey());
            }
            businesss.add(activityCount.getBusiness().replace("ad-", ""));
        }
        if (businesss.size() > 0) {
            map.put("businesss", businesss);
        }
        List adpositionVos = Lists.newArrayList();
        if (!map.isEmpty()) {
            adpositionVos = this.adPositionMapperExt.findAllBusinesses(map);
        }
        HashMap<String, AdpositionVo> adpositionVoMap = new HashMap<String, AdpositionVo>();
        for (AdpositionVo adpositionVo : adpositionVos) {
            adpositionVoMap.put(adpositionVo.getAppkey() + "-" + adpositionVo.getBusiness(), adpositionVo);
        }
        ArrayList<ActivityAppBusinessVo> activityAppBusinessVos = new ArrayList<ActivityAppBusinessVo>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityAppBusinessVo activityAppBusinessVo = new ActivityAppBusinessVo();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityAppBusinessVo);
            String businessName = "";
            if (!StringUtils.isEmpty((String)activityCount.getBusiness())) {
                businessName = adpositionVoMap.getOrDefault(activityCount.getAppKey() + "-" + activityCount.getBusiness().replace("ad-", ""), new AdpositionVo()).getName();
            }
            activityAppBusinessVo.setBusinessName(StringUtils.isEmpty((String)businessName) ? "" : businessName);
            activityAppBusinessVos.add(activityAppBusinessVo);
        }
        ExcelUtil.exportExcel(activityAppBusinessVos, null, null, ActivityAppBusinessVo.class, "\u6d3b\u52a8\u62a5\u8868.xls", response);
    }

    @Override
    public ResultModel pullActivityByDate(List<ActivityCount> activityCounts) {
        ResultModel resultModel = new ResultModel();
        ArrayList<ActivityDate> activityDates = new ArrayList<ActivityDate>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityDate activityDate = new ActivityDate();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityDate);
            activityDate.setPerClickPv(activityCount.getPerClickPv());
            activityDate.setPerClickPvChange(this.getPerChangeName(activityCount));
            activityDates.add(activityDate);
        }
        Pagination pagination = new Pagination();
        pagination.setList(activityDates);
        resultModel.setReturnValue((Object)pagination);
        return resultModel;
    }

    @Override
    public void activityReportByDateExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        ArrayList<ActivityDate> activityDates = new ArrayList<ActivityDate>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityDate activityDate = new ActivityDate();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityDate);
            activityDates.add(activityDate);
        }
        ExcelUtil.exportExcel(activityDates, null, null, ActivityDate.class, "\u6d3b\u52a8\u62a5\u8868.xls", response);
    }

    @Override
    public ResultModel pullActivityBusinessByDate(List<ActivityCount> activityCounts) {
        ResultModel resultModel = new ResultModel();
        ArrayList<ActivityBusinessDate> activityBusinessDates = new ArrayList<ActivityBusinessDate>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityBusinessDate activityBusinessDate = new ActivityBusinessDate();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityBusinessDate);
            activityBusinessDate.setPerClickPv(activityCount.getPerClickPv());
            activityBusinessDate.setPerClickPvChange(this.getPerChangeName(activityCount));
            activityBusinessDates.add(activityBusinessDate);
        }
        Pagination pagination = new Pagination();
        pagination.setList(activityBusinessDates);
        resultModel.setReturnValue((Object)pagination);
        return resultModel;
    }

    @Override
    public void activityReportBusinessByDateExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        ArrayList<ActivityBusinessDate> activityBusinessDates = new ArrayList<ActivityBusinessDate>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityBusinessDate activityBusinessDate = new ActivityBusinessDate();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityBusinessDate);
            activityBusinessDates.add(activityBusinessDate);
        }
        ExcelUtil.exportExcel(activityBusinessDates, null, null, ActivityBusinessDate.class, "\u6d3b\u52a8\u62a5\u8868.xls", response);
    }

    @Override
    public String getActivityIds(ActivityReportRo activityReportRo) {
        List ids;
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)activityReportRo.getKeywords())) {
            if (StringUtils.isNumeric((String)activityReportRo.getKeywords().trim())) {
                map.put("activityid", activityReportRo.getKeywords().trim());
            } else {
                map.put("activityname", activityReportRo.getKeywords().trim());
            }
        }
        if (!StringUtils.isEmpty((String)activityReportRo.getActivityType())) {
            map.put("activitytype", activityReportRo.getActivityType().trim());
        }
        if (StringUtil.isNotBlank((CharSequence)activityReportRo.getActivityplan())) {
            map.put("activityPlan", activityReportRo.getActivityplan());
        }
        if (StringUtil.isNotBlank((CharSequence)activityReportRo.getActivityDesigner())) {
            map.put("activityDesigner", activityReportRo.getActivityDesigner());
        }
        if ((ids = this.activityMapper.findListBykeywords(map)).isEmpty()) {
            return null;
        }
        return JSON.toJSONString((Object)ids);
    }

    @Override
    public String getAppKeys(String appName) {
        if (!StringUtils.isEmpty((String)appName)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("mediaName", appName.trim());
            List appMsgs = this.infoAppMsgMapperExt.findAppkeys(map);
            if (appMsgs.isEmpty()) {
                return null;
            }
            ArrayList<String> appKeys = new ArrayList<String>();
            for (InfoAppMsg infoAppMsg : appMsgs) {
                appKeys.add(infoAppMsg.getAppkey());
            }
            return JSON.toJSONString(appKeys);
        }
        return null;
    }

    @Override
    public String getBusiness(String appKey, String businessName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appKey", appKey);
        if (!StringUtils.isEmpty((String)businessName)) {
            map.put("businessName", businessName);
        }
        ArrayList<String> list = new ArrayList<String>();
        List businesses = this.adPositionMapperExt.findBusinesses(map);
        if (businesses.isEmpty()) {
            return null;
        }
        for (AdpositionVo adpositionVo : businesses) {
            list.add("ad-" + adpositionVo.getBusiness());
        }
        return JSON.toJSONString(list);
    }

    @Override
    public List<InfoActivityMsgDto> getActivityMsg(String keyWords, String activityType, String activityPlan) {
        List list;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)keyWords)) {
            if (StringUtils.isNumeric((String)keyWords.trim())) {
                map.put("activityid", Integer.parseInt(keyWords.trim()));
            } else {
                map.put("activityname", keyWords.trim());
            }
        }
        if (!StringUtils.isEmpty((String)activityType)) {
            map.put("activitytype", activityType.trim());
        }
        if (StringUtil.isNotBlank((CharSequence)activityPlan)) {
            map.put("activityPlan", activityPlan);
        }
        if ((list = this.activityMapper.findListBykeywords2(map)).isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public void appBusinessActivityDateReportExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        ArrayList<AppBusinessActivityDateVo> activityBusinessDates = new ArrayList<AppBusinessActivityDateVo>();
        for (ActivityCount activityCount : activityCounts) {
            AppBusinessActivityDateVo activityBusinessDate = new AppBusinessActivityDateVo();
            BeanUtils.copyProperties((Object)activityCount, (Object)activityBusinessDate);
            activityBusinessDates.add(activityBusinessDate);
        }
        ExcelUtil.exportExcel(activityBusinessDates, null, null, AppBusinessActivityDateVo.class, "\u5f00\u53d1\u8005\u65e5\u62a5\u5b50\u94fe\u63a5\u6d3b\u52a8\u6309\u65e5\u62a5\u8868.xls", response);
    }

    private String getPerChangeName(ActivityCount appCount) {
        return appCount.getPerClickPvChange() != null && appCount.getPerClickPvChange() != 0.0 ? appCount.getPerClickPvChange() + "%" : "-";
    }

    private void setDesignerAndPlanner(ActivityWithBLOBs activityWithBLOB, ActivityDailyReportVo activityVo) {
        if (activityWithBLOB != null) {
            String designer = this.dictionariesService.findNameByCode(activityWithBLOB.getActivityDesigner(), "huodongui");
            activityVo.setActivityDesigner(designer);
            String planner = this.dictionariesService.findNameByCode(activityWithBLOB.getActivityPlanner(), "actplan");
            activityVo.setActivityPlanner(planner);
        }
    }
}

