/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.datapark.impl;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.AnalysisParamsDTO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisAppOSVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisMediaVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisPaymentTypeVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisRegionVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisTagTypeVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisTrendVO;
import com.bxm.report.facade.datapark.DataparkTicketAnalysisIntegration;
import com.bxm.report.service.datapark.TicketAnalysisService;
import com.bxm.report.service.utils.TicketAnalysisHelper;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketAnalysisServiceImpl
implements TicketAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(TicketAnalysisServiceImpl.class);
    @Autowired
    private DataparkTicketAnalysisIntegration analysisIntegration;
    @Autowired
    private TicketAnalysisHelper ticketAnalysisHelper;

    @Override
    public Page analysis(com.bxm.report.model.dto.analysis.AnalysisParamsDTO paramsDTO, String analysisType) {
        AnalysisParamsDTO analysisParamsDTO = this.convert(paramsDTO);
        switch (analysisType) {
            case "TREND": {
                return this.ticketAnalysisHelper.convertAndBuildByTrend((Page<AnalysisTrendVO>)this.analysisIntegration.trend(analysisParamsDTO));
            }
            case "MEDIA": {
                if (StringUtils.isBlank((CharSequence)paramsDTO.getMediaGroupType())) {
                    paramsDTO.setMediaGroupType("MEDIA");
                }
                return this.ticketAnalysisHelper.convertAndBuildByMedia((Page<AnalysisMediaVO>)this.analysisIntegration.media(analysisParamsDTO));
            }
            case "TAG_TYPE": {
                return this.ticketAnalysisHelper.convertAndBuildByTagType((Page<AnalysisTagTypeVO>)this.analysisIntegration.tagType(analysisParamsDTO));
            }
            case "REGION": {
                if (StringUtils.isBlank((CharSequence)paramsDTO.getRegionGroupType())) {
                    paramsDTO.setRegionGroupType("PROVINCE");
                }
                return this.ticketAnalysisHelper.convertAndBuildByRegion((Page<AnalysisRegionVO>)this.analysisIntegration.region(analysisParamsDTO));
            }
            case "APP_OS": {
                return this.ticketAnalysisHelper.convertAndBuildByAppOS((Page<AnalysisAppOSVO>)this.analysisIntegration.appOS(analysisParamsDTO));
            }
            case "PAYMENT_TYPE": {
                return this.ticketAnalysisHelper.convertAndBuildByPaymentType((Page<AnalysisPaymentTypeVO>)this.analysisIntegration.paymentType(analysisParamsDTO));
            }
        }
        return null;
    }

    @Override
    public Map analysisChart(com.bxm.report.model.dto.analysis.AnalysisParamsDTO paramsDTO, String analysisType) {
        AnalysisParamsDTO analysisParamsDTO = this.convert(paramsDTO);
        Map map = this.analysisIntegration.commonAnalysisChat(analysisParamsDTO, analysisType);
        if (MapUtils.isEmpty((Map)map)) {
            return Collections.emptyMap();
        }
        if ("MEDIA".equals(analysisType)) {
            return this.ticketAnalysisHelper.commonAnalysisChat(map, analysisType, paramsDTO.getMediaGroupType());
        }
        if ("TAG_TYPE".equals(analysisType)) {
            return this.ticketAnalysisHelper.commonAnalysisChat(map, analysisType, "");
        }
        return map;
    }

    private AnalysisParamsDTO convert(com.bxm.report.model.dto.analysis.AnalysisParamsDTO paramsDTO) {
        AnalysisParamsDTO analysisParamsDTO = new AnalysisParamsDTO();
        analysisParamsDTO.setSortType(paramsDTO.getSortType());
        analysisParamsDTO.setSortFieldName(paramsDTO.getSortFieldName());
        analysisParamsDTO.setRegionGroupType(paramsDTO.getRegionGroupType());
        analysisParamsDTO.setMediaGroupType(paramsDTO.getMediaGroupType());
        if (null != paramsDTO.getTicketId()) {
            analysisParamsDTO.setTicketId(String.valueOf(paramsDTO.getTicketId()));
        }
        analysisParamsDTO.setMediaId(paramsDTO.getMediaId());
        analysisParamsDTO.setAdPositionId(paramsDTO.getAdPositionId());
        analysisParamsDTO.setPageNum(paramsDTO.getPageNum());
        analysisParamsDTO.setPageSize(paramsDTO.getPageSize());
        analysisParamsDTO.setStartTime(paramsDTO.getStartTime());
        analysisParamsDTO.setEndTime(paramsDTO.getEndTime());
        return analysisParamsDTO;
    }
}

