/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.datapark.impl;

import com.bxm.dao.adkeeper.TblActivityMapper;
import com.bxm.dao.venue.VenueMapper;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.venue.model.dto.VenueReportDto;
import com.bxm.datapark.facade.venue.model.vo.VenueReportVo;
import com.bxm.report.facade.datapark.DataparkVenuePullerIntegration;
import com.bxm.report.model.dao.activity.TblActivity;
import com.bxm.report.model.dao.venue.VenueDao;
import com.bxm.report.service.datapark.VenueReportService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VenueReportServiceImpl
implements VenueReportService {
    @Autowired
    private DataparkVenuePullerIntegration dataparkVenuePullerIntegration;
    @Autowired
    private VenueMapper venueMapper;
    @Autowired
    private TblActivityMapper tblActivityMapper;

    @Override
    public Page<VenueReportVo> venueReport(VenueReportDto dto) {
        List venueDaos = this.venueMapper.findAllForReport(dto.getVenueName());
        if (CollectionUtils.isEmpty((Collection)venueDaos)) {
            return new Page();
        }
        ArrayList<String> venueIds = new ArrayList<String>();
        for (VenueDao dao : venueDaos) {
            venueIds.add(dao.getId().toString());
        }
        dto.setVenueIds(venueIds);
        Page page = this.dataparkVenuePullerIntegration.venueReport(dto);
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            Map<Integer, VenueDao> map = venueDaos.stream().collect(Collectors.toMap(VenueDao::getId, val -> val));
            for (VenueReportVo vo : page.getList()) {
                VenueDao venueDao;
                if (!StringUtils.isNumericSpace((String)vo.getVenueId()) || !MapUtils.isNotEmpty(map) || null == (venueDao = map.get(Integer.valueOf(vo.getVenueId())))) continue;
                vo.setVenueName(venueDao.getName());
            }
        }
        return page;
    }

    @Override
    public Page<VenueReportVo> venueActivityReport(VenueReportDto dto) {
        Page page = this.dataparkVenuePullerIntegration.venueReport(dto);
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            ArrayList<String> ids = new ArrayList<String>();
            for (VenueReportVo vo : page.getList()) {
                if (!StringUtils.isNotBlank((String)vo.getActivityId())) continue;
                ids.add(vo.getActivityId());
            }
            if (ids.size() > 0) {
                List activiites = this.tblActivityMapper.findActivityNameByIds(ids);
                Map<Long, String> activiitesMap = activiites.stream().collect(Collectors.toMap(TblActivity::getId, TblActivity::getActivityName));
                for (VenueReportVo vo : page.getList()) {
                    if (!StringUtils.isNumericSpace((String)vo.getActivityId())) continue;
                    vo.setActivityName(activiitesMap.get(Long.valueOf(vo.getActivityId())));
                }
            }
        }
        return page;
    }

    @Override
    public Page<VenueReportVo> venueDateReport(VenueReportDto dto) {
        return this.dataparkVenuePullerIntegration.venueDateReport(dto);
    }
}

