/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.media.impl;

import com.bxm.dao.media.ext.AdTicketPositionWeightMapperExt;
import com.bxm.report.model.common.CommonSearchDto;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.model.dto.media.InfoMediaMsgDto;
import com.bxm.report.model.dto.media.InfoPositionMsgDto;
import com.bxm.report.model.enums.RoleEnum;
import com.bxm.report.service.media.MediaPositionService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MediaPositionServiceImpl
implements MediaPositionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionServiceImpl.class);
    @Autowired
    private AdTicketPositionWeightMapperExt mediaPostionWeightExt;

    @Override
    public List<InfoMediaMsgDto> findMediaByRole(User user, CommonSearchDto search) {
        if (this.getMJCode(user) != null) {
            LOGGER.info("\u666e\u901a\u5a92\u4ecb\u67e5\u8be2\u5a92\u4f53");
            return this.mediaPostionWeightExt.findMediaByRole(search, this.getMJCode(user));
        }
        return this.findMediaAll(search);
    }

    @Override
    public List<InfoMediaMsgDto> findMediaAll(CommonSearchDto search) {
        return this.mediaPostionWeightExt.findMediaAll(search);
    }

    @Override
    public List<InfoPositionMsgDto> findPositionAll(Map<String, Object> params) {
        return this.mediaPostionWeightExt.findPositionAll2(params);
    }

    private String getMJCode(User user) {
        List codes = user.getRoleCodes();
        if (!codes.contains(RoleEnum.MJLEADER.getCode()) && codes.contains(RoleEnum.MJ.getCode())) {
            return user.getUserNameContainRole(RoleEnum.MJ.getCode());
        }
        return null;
    }
}

