/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.report.impl;

import com.bxm.dao.adkeeper.AdTicketTagConfMapper;
import com.bxm.dao.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.report.model.constant.TicketConstant;
import com.bxm.report.model.dao.adticket.AdTicketTagConf;
import com.bxm.report.model.dao.tbltag.TblAdPostionTag;
import com.bxm.report.model.dto.adticket.AdTicketTagConfDO;
import com.bxm.report.service.report.AdTicketTagConfService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdTicketTagConfServiceImpl
implements AdTicketTagConfService {
    private static final Logger logger = LoggerFactory.getLogger(AdTicketTagConfServiceImpl.class);
    @Autowired
    private AdTicketTagConfMapper adTicketTagConfMapper;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;

    @Override
    public Integer add(AdTicketTagConf conf) {
        return this.adTicketTagConfMapper.insert(conf);
    }

    @Override
    public Integer addBatch(String tags, Long ticketId) {
        if (tags == null) {
            return null;
        }
        String[] tagsArray = tags.split(",");
        List<String> list = Arrays.asList(tagsArray);
        Integer result = this.adTicketTagConfMapper.addBatch(list, ticketId);
        return result;
    }

    @Override
    public Integer delete(Long ticketId) {
        return this.adTicketTagConfMapper.deleteByTicketId(ticketId);
    }

    @Override
    public String findByTicketId(Long ticketId) {
        String ads = "";
        List adTagConfList = this.adTicketTagConfMapper.findByTicketId(ticketId);
        if (adTagConfList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < adTagConfList.size(); ++i) {
            ads = i == adTagConfList.size() - 1 ? ads + ((AdTicketTagConf)adTagConfList.get(i)).getTagCode() : ads + ((AdTicketTagConf)adTagConfList.get(i)).getTagCode() + ",";
        }
        return ads;
    }

    @Override
    public List<Long> findTicketIdsByOneLevelTagCode(Integer oneLevelTagCode) {
        if (null == oneLevelTagCode) {
            return Collections.emptyList();
        }
        List tblAdTagVos = this.tblAdPostionTagMapperExt.findTagsByOneLevelCode(oneLevelTagCode);
        if (CollectionUtils.isEmpty((Collection)tblAdTagVos)) {
            logger.warn(">>>>>>>>>>no tag belong :", (Object)oneLevelTagCode);
            return Collections.emptyList();
        }
        List codes = tblAdTagVos.stream().map(TblAdPostionTag::getCode).collect(Collectors.toList());
        return this.adTicketTagConfMapper.findTicketIds(codes);
    }

    @Override
    public Map<Long, String> findClassifyTagName(List<Long> ticketIds) {
        if (CollectionUtils.isEmpty(ticketIds)) {
            return Collections.emptyMap();
        }
        List adTicketTagConfDOS = this.adTicketTagConfMapper.findTicketBelongCodeName(ticketIds, TicketConstant.TicketTag.TAG_TYPE_CLASSIFY);
        HashMap<Long, String> tagNameMap = new HashMap<Long, String>(adTicketTagConfDOS.size());
        for (AdTicketTagConfDO adTicketTagConfDO : adTicketTagConfDOS) {
            String fullNameStr = adTicketTagConfDO.getFullNameStr();
            if (StringUtils.isBlank((CharSequence)fullNameStr)) continue;
            Integer indexOf = fullNameStr.indexOf(".");
            String tagName = indexOf < 0 ? fullNameStr : fullNameStr.substring(0, indexOf);
            String name = (String)tagNameMap.get(adTicketTagConfDO.getTicketId());
            if (StringUtils.isBlank((CharSequence)name)) {
                tagNameMap.put(adTicketTagConfDO.getTicketId(), tagName);
                continue;
            }
            tagNameMap.put(adTicketTagConfDO.getTicketId(), StringUtils.join((Object[])new String[]{name, ",", tagName}));
        }
        return tagNameMap;
    }

    @Override
    public List<Long> checkTicketBelongOneLevelTagCode(List<Long> ticketIds, Integer oneLevelTagCode) {
        if (CollectionUtils.isEmpty(ticketIds) || null == oneLevelTagCode) {
            return Collections.emptyList();
        }
        List tblAdTagVos = this.tblAdPostionTagMapperExt.findTagsByOneLevelCode(oneLevelTagCode);
        if (CollectionUtils.isEmpty((Collection)tblAdTagVos)) {
            logger.warn(">>>>>>>>>>no tag belong :", (Object)oneLevelTagCode);
            return Collections.emptyList();
        }
        List codes = tblAdTagVos.stream().map(TblAdPostionTag::getCode).collect(Collectors.toList());
        return this.adTicketTagConfMapper.checkTicketBelongOneLevelCode(ticketIds, codes);
    }
}

