/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.dao.adflowpackage.AdTicketFlowPackageMapper;
import com.bxm.dao.adkeeper.AdTicketMapper;
import com.bxm.dao.adkeeper.AdTicketOcpcMapper;
import com.bxm.dao.adkeeper.TblActivityMapper;
import com.bxm.dao.adkeeper.TblAdIconClickPvUpdateMapper;
import com.bxm.dao.adkeeper.ext.TblAdIconClickPvUpdateMapperExt;
import com.bxm.log.facade.dao.Page;
import com.bxm.log.facade.dto.LogModelDto;
import com.bxm.log.facade.service.LogsService;
import com.bxm.report.facade.app.AppEntranceFacadeIntegration;
import com.bxm.report.facade.datapark.DataparkAppPullerIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.common.Dictionaries;
import com.bxm.report.model.dao.activity.ActivityCount;
import com.bxm.report.model.dao.activity.ActivityWithBLOBs;
import com.bxm.report.model.dao.adflowpackage.AdTicketFlowPackageConf;
import com.bxm.report.model.dao.adticket.AdTicket;
import com.bxm.report.model.dao.adticket.AdTicketOcpcConf;
import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.dao.app.InfoAppMsg;
import com.bxm.report.model.dao.appcount.AppCount;
import com.bxm.report.model.dao.icon.TblAdIconClickPvUpdate;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.model.dto.advertiser.AdvertiserDto;
import com.bxm.report.model.enums.RoleEnum;
import com.bxm.report.model.vo.activity.ActivityVo;
import com.bxm.report.model.vo.adposition.AdpositionVo;
import com.bxm.report.model.vo.app.AppBusinessByDateVo;
import com.bxm.report.model.vo.app.AppBusinessTicketDateVo;
import com.bxm.report.model.vo.app.AppBusinessTicketVo;
import com.bxm.report.model.vo.app.AppBusinessVo;
import com.bxm.report.model.vo.app.AppByDateVo;
import com.bxm.report.model.vo.app.AppTicketDateVo;
import com.bxm.report.model.vo.app.AppTicketVo;
import com.bxm.report.model.vo.appcount.AppCountVo;
import com.bxm.report.service.adkeeper.AdPositionService;
import com.bxm.report.service.adkeeper.DictionariesService;
import com.bxm.report.service.adkeeper.InfoActivityCertificateService;
import com.bxm.report.service.adkeeper.InfoAppMsgService;
import com.bxm.report.service.report.IAppReportService;
import com.bxm.report.service.report.ReportCommonService;
import com.bxm.report.service.utils.DateFormatUtil;
import com.bxm.report.service.utils.DateParkUtil;
import com.bxm.report.service.utils.DoubleUtil;
import com.bxm.report.service.utils.ListUtil;
import com.bxm.report.service.utils.SortUtils;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AppReportServiceImpl
implements IAppReportService {
    Logger logger = LoggerFactory.getLogger(AppReportServiceImpl.class);
    @Autowired
    private AdPositionService adPositionService;
    @Autowired
    private InfoAppMsgService infoAppMsgService;
    @Autowired
    private DataparkAppPullerIntegration dataparkAppPullerIntegration;
    @Autowired
    private InfoActivityCertificateService infoActivityCertificateService;
    @Autowired
    private ReportCommonService reportCommonService;
    @Autowired
    private TblActivityMapper activityMapper;
    @Autowired
    private TblAdIconClickPvUpdateMapper tblAdIconClickPvUpdateMapper;
    @Autowired
    private TblAdIconClickPvUpdateMapperExt tblAdIconClickPvUpdateMapperExt;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    AdTicketOcpcMapper adTicketOcpcMapper;
    @Autowired
    AdTicketFlowPackageMapper adTicketFlowPackageMapper;
    @Autowired
    private LogsService logsService;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    private Pattern pattern = Pattern.compile("\"times\"\\s*:\\s*\"(\\d{1,2}-\\d{1,2}-\\d+(\\s*,\\s*\\d{1,2}-\\d{1,2}-\\d+)*)\"");
    @Autowired
    private Mapper mapper;
    @Resource
    private AppEntranceFacadeIntegration appEntranceFacadeIntegration;

    @Override
    public com.bxm.datapark.facade.Page<AppCountVo> getAppCount(String datetime, String keyword, User user, Integer pageSize, Integer pageNum, String sortName, String sortType, String onlineStart, String onlineEnd) throws IOException {
        String roleCode = this.getRoleCode(user);
        List<Object> infoAppMsgs = new ArrayList();
        ArrayList appKeysList = Lists.newArrayList();
        HashMap infoAppMsgMap = Maps.newHashMap();
        StringBuffer appKeys = new StringBuffer();
        infoAppMsgs = this.infoAppMsgService.findAllAppkeys(keyword, roleCode);
        if (!CollectionUtils.isNotEmpty(infoAppMsgs)) {
            return new com.bxm.datapark.facade.Page();
        }
        infoAppMsgs.stream().forEach(infoAppMsg -> {
            appKeysList.add(infoAppMsg.getAppkey());
            infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
            appKeys.append(infoAppMsg.getAppkey() + ",");
        });
        if (appKeysList == null || appKeysList.size() == 0) {
            return new com.bxm.datapark.facade.Page();
        }
        Map<String, String> appKeyMap = this.adPositionService.findAppKeysByOnline(appKeysList, onlineStart, onlineEnd);
        if (appKeyMap == null || appKeyMap.size() == 0) {
            return new com.bxm.datapark.facade.Page();
        }
        ArrayList appKeysListTemp = new ArrayList();
        appKeysList.forEach(appKey -> {
            if (appKeyMap.containsKey(appKey)) {
                appKeysListTemp.add(appKey);
            }
        });
        com.bxm.datapark.facade.Page appCountPage = this.dataparkAppPullerIntegration.getAppCountPage(datetime, pageSize, pageNum, sortName, sortType, JSON.toJSONString(appKeysListTemp));
        List listTemp = appCountPage.getList();
        if (!CollectionUtils.isNotEmpty((Collection)listTemp)) {
            return new com.bxm.datapark.facade.Page();
        }
        this.getAppKeys(keyword, infoAppMsgMap, appKeysList, appKeys, listTemp);
        Map<String, Integer> businessNumberMaps = this.adPositionService.getBusinessNumberByAppKeys(appKeysList);
        ArrayList<AppCountVo> list = new ArrayList<AppCountVo>();
        com.bxm.datapark.facade.Page appCountPageRs = new com.bxm.datapark.facade.Page();
        this.mapper.map((Object)appCountPage, (Object)appCountPageRs);
        Integer business = 0;
        if (appCountPageRs != null && CollectionUtils.isNotEmpty((Collection)listTemp)) {
            for (AppCount appCount : listTemp) {
                AppCountVo appCountVo = new AppCountVo();
                this.mapper.map((Object)appCount, (Object)appCountVo);
                Double perclickPv = appCount.getPerClickPv() == null ? 0.0 : appCount.getPerClickPv();
                appCountVo.setPerClickPv(perclickPv);
                Double perclickPvChange = appCount.getPerClickPvChange() == null ? 0.0 : appCount.getPerClickPvChange();
                appCountVo.setPerClickPvChange(perclickPvChange == 0.0 ? "-" : perclickPvChange + "%");
                String appName = infoAppMsgMap.getOrDefault(appCountVo.getAppKey(), new InfoAppMsg()).getAppname();
                appCountVo.setAppName(StringUtils.isNotEmpty((CharSequence)appName) ? appName : "");
                Integer businessNumber = businessNumberMaps.getOrDefault(appCountVo.getAppKey(), Integer.valueOf("0"));
                appCountVo.setBusinessCount(businessNumber);
                if (appKeyMap.get(appCount.getAppKey()) == null) {
                    appCountVo.setOnlineTime("");
                } else {
                    appCountVo.setOnlineTime(appKeyMap.get(appCount.getAppKey()));
                }
                list.add(appCountVo);
                business = business + businessNumber;
            }
            ((AppCountVo)list.get(0)).setBusinessCount(business);
            appCountPageRs.setList(list);
        }
        return appCountPageRs;
    }

    @Override
    public List<AppCountVo> getAppCountExport(String datetime, String keyword, User user, String sortName, String sortType, String onlineStart, String onlineEnd) throws IOException {
        String roleCode = this.getRoleCode(user);
        List<Object> infoAppMsgs = new ArrayList();
        ArrayList appKeysList = Lists.newArrayList();
        HashMap infoAppMsgMap = Maps.newHashMap();
        StringBuffer appKeys = new StringBuffer();
        infoAppMsgs = this.infoAppMsgService.findAllAppkeys(keyword, roleCode);
        if (!CollectionUtils.isNotEmpty(infoAppMsgs)) {
            return new ArrayList<AppCountVo>();
        }
        infoAppMsgs.stream().forEach(infoAppMsg -> {
            appKeysList.add(infoAppMsg.getAppkey());
            infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
            appKeys.append(infoAppMsg.getAppkey() + ",");
        });
        if (appKeysList == null || appKeysList.size() == 0) {
            return new ArrayList<AppCountVo>();
        }
        Map<String, String> appKeyMap = this.adPositionService.findAppKeysByOnline(appKeysList, onlineStart, onlineEnd);
        if (appKeyMap == null || appKeyMap.size() == 0) {
            return new ArrayList<AppCountVo>();
        }
        ArrayList appKeysListTemp = new ArrayList();
        appKeysList.forEach(appKey -> {
            if (appKeyMap.containsKey(appKey)) {
                appKeysListTemp.add(appKey);
            }
        });
        List appCountVos = this.dataparkAppPullerIntegration.getAppCountVos(datetime, sortName, sortType, JSON.toJSONString(appKeysListTemp));
        if (!CollectionUtils.isNotEmpty((Collection)appCountVos)) {
            return new ArrayList<AppCountVo>();
        }
        this.getAppKeys(keyword, infoAppMsgMap, appKeysList, appKeys, appCountVos);
        ArrayList<AppCountVo> list = new ArrayList<AppCountVo>();
        this.copyList(appCountVos, list);
        Map<String, Integer> businessNumberMaps = this.adPositionService.getBusinessNumberByAppKeys(appKeysList);
        if (CollectionUtils.isNotEmpty(list)) {
            for (AppCountVo appCountVo : list) {
                String appName = infoAppMsgMap.getOrDefault(appCountVo.getAppKey(), new InfoAppMsg()).getAppname();
                Integer businessNumber = businessNumberMaps.getOrDefault(appCountVo.getAppKey(), Integer.valueOf("0"));
                appCountVo.setBusinessCount(businessNumber);
                appCountVo.setAppName(StringUtils.isNotEmpty((CharSequence)appName) ? appName : "");
            }
        }
        if (user.getRoleCodes().contains(RoleEnum.BD.getCode()) && !user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode())) {
            for (int i = 0; i < list.size(); ++i) {
                ((AppCountVo)list.get(i)).setMidPagePv(Integer.valueOf(0));
                ((AppCountVo)list.get(i)).setMidPvChange("");
                ((AppCountVo)list.get(i)).setIndexPv(Integer.valueOf(0));
                ((AppCountVo)list.get(i)).setIndexPvChange("");
                ((AppCountVo)list.get(i)).setIndexUv(Integer.valueOf(0));
                ((AppCountVo)list.get(i)).setIndexUvChange("");
                ((AppCountVo)list.get(i)).setIncome(Double.valueOf(0.0));
                ((AppCountVo)list.get(i)).setIncomeChange("");
                ((AppCountVo)list.get(i)).setBxmIncome(Double.valueOf(0.0));
                ((AppCountVo)list.get(i)).setBxmIncomeChange("");
                ((AppCountVo)list.get(i)).setOpenPvAurp(Double.valueOf(0.0));
                ((AppCountVo)list.get(i)).setOpenPvAurpChange("");
                ((AppCountVo)list.get(i)).setUvAurp(Double.valueOf(0.0));
                ((AppCountVo)list.get(i)).setUvAurpChange("");
                ((AppCountVo)list.get(i)).setBxmAurp(Double.valueOf(0.0));
                ((AppCountVo)list.get(i)).setBxmAurpChange("");
            }
            return list;
        }
        return list;
    }

    private void getAppKeys(String keyword, Map<String, InfoAppMsg> infoAppMsgMap, List<String> appKeysList, StringBuffer appKeys, List<AppCount> appCounts) {
        if (StringUtils.isEmpty((CharSequence)keyword)) {
            appCounts.stream().forEach(appCount -> {
                appKeys.append(appCount.getAppKey() + ",");
                appKeysList.add(appCount.getAppKey());
            });
            List<InfoAppMsg> infoAppByAppkeys = this.infoAppMsgService.findInfoAppByAppkeys(appKeys);
            if (CollectionUtils.isNotEmpty(infoAppByAppkeys)) {
                infoAppByAppkeys.stream().forEach(infoAppMsg -> infoAppMsgMap.put(infoAppMsg.getAppkey(), (InfoAppMsg)infoAppMsg));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public com.bxm.datapark.facade.Page<AppBusinessVo> findAppBusinessCount(String datetime, String keyword, String appKey, Integer pageSize, Integer pageNum, String sortName, String sortType, String onlineStart, String onlineEnd) throws Exception {
        ArrayList arrayList = new ArrayList();
        ArrayList businesses = Lists.newArrayList();
        StringBuffer sbBusinesses = new StringBuffer("");
        HashMap businessMap = new HashMap();
        HashMap adpositionVoMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            List<AdpositionVo> list = this.adPositionService.findBusinesses(appKey, keyword, onlineStart, onlineEnd);
            if (!CollectionUtils.isNotEmpty(list)) return new com.bxm.datapark.facade.Page();
            this.dealBusiness(list, businesses, adpositionVoMap, sbBusinesses);
        } else {
            List<AppCountVo> appCountVos = this.adPositionService.findBusinessByAppkeyTime(appKey, onlineStart, onlineEnd);
            if (appCountVos == null || appCountVos.size() == 0) {
                return new com.bxm.datapark.facade.Page();
            }
            appCountVos.forEach(appCountVo -> businessMap.put("ad-" + appCountVo.getBusiness(), appCountVo.getOnlineTime()));
        }
        com.bxm.datapark.facade.Page appBusinessCountVoPage = this.dataparkAppPullerIntegration.getAppBusinessCountVoPage(datetime, appKey, pageSize, pageNum, sortName, sortType, JSON.toJSONString((Object)businesses));
        String preDate = DateParkUtil.getPreDate(datetime);
        com.bxm.datapark.facade.Page appBusinessCountVoPagePre = this.dataparkAppPullerIntegration.getAppBusinessCountVoPage(preDate, appKey, pageSize, pageNum, sortName, sortType, JSON.toJSONString((Object)businesses));
        List listTemp = appBusinessCountVoPage.getList();
        List listPre = appBusinessCountVoPagePre.getList();
        if (!CollectionUtils.isNotEmpty((Collection)listTemp)) {
            return new com.bxm.datapark.facade.Page();
        }
        this.getBusinesses(appKey, keyword, adpositionVoMap, sbBusinesses, listTemp);
        ArrayList<AppBusinessVo> list = new ArrayList<AppBusinessVo>();
        com.bxm.datapark.facade.Page appBusinessPageRs = new com.bxm.datapark.facade.Page();
        this.mapper.map((Object)appBusinessCountVoPage, (Object)appBusinessPageRs);
        if (!CollectionUtils.isNotEmpty((Collection)listTemp)) return appBusinessPageRs;
        for (AppCount appCount : listTemp) {
            AppBusinessVo appBusinessVo = new AppBusinessVo();
            this.mapper.map((Object)appCount, (Object)appBusinessVo);
            appBusinessVo.setLandingRateChange(appCount.getLandingRateChange() + "%");
            if (StringUtils.isNotEmpty((CharSequence)appCount.getBusiness())) {
                String name = adpositionVoMap.getOrDefault(appCount.getBusiness().replaceAll("ad-", ""), new AdpositionVo()).getName();
                appBusinessVo.setBusinessName(name);
            }
            if (businessMap != null) {
                appBusinessVo.setOnlineTime((String)businessMap.get(appCount.getBusiness()));
            }
            list.add(appBusinessVo);
        }
        appBusinessPageRs.setList(this.getUpdateList(listPre, list, datetime, appKey, appBusinessCountVoPage.getTotal(), appBusinessCountVoPage.getSize()));
        return appBusinessPageRs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<AppBusinessVo> findAppBusinessCountExport(String datetime, String keyword, String appKey, String sortName, String sortType, String onlineStart, String onlineEnd) throws IOException {
        List<AdpositionVo> adpositionVos = this.adPositionService.findBusinesses(appKey, keyword, onlineStart, onlineEnd);
        ArrayList businesses = Lists.newArrayList();
        StringBuffer sbBusinesses = new StringBuffer("");
        HashMap adpositionVoMap = Maps.newHashMap();
        HashMap businessMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            adpositionVos = this.adPositionService.findBusinesses(appKey, keyword, onlineStart, onlineEnd);
            if (!CollectionUtils.isNotEmpty(adpositionVos)) return new ArrayList<AppBusinessVo>();
            this.dealBusiness(adpositionVos, businesses, adpositionVoMap, sbBusinesses);
        } else {
            List<AppCountVo> appCountVos = this.adPositionService.findBusinessByAppkeyTime(appKey, onlineStart, onlineEnd);
            if (appCountVos == null || appCountVos.size() == 0) {
                return new ArrayList<AppBusinessVo>(){};
            }
            appCountVos.forEach(appCountVo -> businessMap.put("ad-" + appCountVo.getBusiness(), appCountVo.getOnlineTime()));
        }
        List appBusinessCountVos = this.dataparkAppPullerIntegration.getAppBusinessCountVos(datetime, appKey, sortName, sortType, JSON.toJSONString((Object)businesses));
        if (!CollectionUtils.isNotEmpty((Collection)appBusinessCountVos)) {
            return new ArrayList<AppBusinessVo>();
        }
        this.getBusinesses(appKey, keyword, adpositionVoMap, sbBusinesses, appBusinessCountVos);
        ArrayList<AppBusinessVo> appBusinessList = new ArrayList<AppBusinessVo>();
        if (!CollectionUtils.isNotEmpty((Collection)appBusinessCountVos)) return appBusinessList;
        for (AppCount appCount : appBusinessCountVos) {
            AppBusinessVo appBusinessVo = new AppBusinessVo();
            this.mapper.map((Object)appCount, (Object)appBusinessVo);
            appBusinessVo.setBusinessName(adpositionVoMap.getOrDefault(appBusinessVo.getBusiness(), new AdpositionVo()).getName());
            if (businessMap != null) {
                appBusinessVo.setOnlineTime((String)businessMap.get(appCount.getBusiness()));
            }
            appBusinessVo.setPerClickPv(appCount.getPerClickPv());
            appBusinessVo.setPerClickPvChange(this.getPerChangeName(appCount));
            appBusinessList.add(appBusinessVo);
        }
        return appBusinessList;
    }

    private void dealBusiness(List<AdpositionVo> adpositionVos, List<String> businesses, Map<String, AdpositionVo> adpositionVoMap, StringBuffer sbBusinesses) {
        adpositionVos.stream().forEach(adpositionVo -> {
            businesses.add("ad-" + adpositionVo.getBusiness().replaceAll("ad-", ""));
            adpositionVoMap.put(adpositionVo.getBusiness().replaceAll("ad-", ""), (AdpositionVo)adpositionVo);
            sbBusinesses.append(adpositionVo.getBusiness().replaceAll("ad-", "") + ",");
        });
    }

    private void getBusinesses(String appKey, String keyword, Map<String, AdpositionVo> adpositionVoMap, StringBuffer sbBusinesses, List<AppCount> appCounts) {
        if (StringUtils.isEmpty((CharSequence)keyword)) {
            appCounts.stream().forEach(appCount -> {
                if (StringUtils.isNotEmpty((CharSequence)appCount.getBusiness())) {
                    sbBusinesses.append(appCount.getBusiness() + ",");
                }
            });
            List<AdpositionVo> byBusinesses = this.adPositionService.findByBusinesses(appKey, sbBusinesses);
            if (CollectionUtils.isNotEmpty(byBusinesses)) {
                byBusinesses.stream().forEach(adpositionVo -> adpositionVoMap.put(adpositionVo.getBusiness().replaceAll("ad-", ""), (AdpositionVo)adpositionVo));
            }
        }
    }

    private void copyList(List<AppCount> appBusinessCountVos, List<AppCountVo> appBusinessList) {
        if (CollectionUtils.isNotEmpty(appBusinessCountVos)) {
            for (AppCount appCount : appBusinessCountVos) {
                AppCountVo appCountVo = new AppCountVo();
                this.mapper.map((Object)appCount, (Object)appCountVo);
                appBusinessList.add(appCountVo);
            }
        }
    }

    @Override
    public List<AppByDateVo> findAppCountDate(String appKey, String startTime, String endTime, String sortName, String sortType) throws IOException {
        List appDateVos = this.dataparkAppPullerIntegration.getAppDateVos(appKey, startTime, endTime, sortName, sortType);
        ArrayList<AppByDateVo> appDateList = new ArrayList<AppByDateVo>();
        if (CollectionUtils.isNotEmpty((Collection)appDateVos)) {
            for (AppCount appCount : appDateVos) {
                AppByDateVo appByDate = new AppByDateVo();
                this.mapper.map((Object)appCount, (Object)appByDate);
                Double perclickpv = appCount.getPerClickPv() == null ? 0.0 : appCount.getPerClickPv();
                appByDate.setPerClickPv(perclickpv);
                appByDate.setPerClickPvChange(this.getPerChangeName(appCount));
                appDateList.add(appByDate);
            }
        }
        return appDateList;
    }

    @Override
    public List<AppBusinessByDateVo> findAppBusinessCountByDate(String appKey, String business, String startTime, String endTime, String sortName, String sortType) throws IOException {
        List appBusinessDateVos = this.dataparkAppPullerIntegration.getAppAppBusinessDateVos(appKey, business, startTime, endTime, sortName, sortType);
        ArrayList<AppBusinessByDateVo> appCountVoList = new ArrayList<AppBusinessByDateVo>();
        if (CollectionUtils.isNotEmpty((Collection)appBusinessDateVos)) {
            for (AppCount appCount : appBusinessDateVos) {
                AppBusinessByDateVo appByDate = new AppBusinessByDateVo();
                this.mapper.map((Object)appCount, (Object)appByDate);
                Double perclickpv = appCount.getPerClickPv() == null ? 0.0 : appCount.getPerClickPv();
                appByDate.setPerClickPv(perclickpv);
                appByDate.setPerClickPvChange(this.getPerChangeName(appCount));
                appCountVoList.add(appByDate);
            }
        }
        return appCountVoList;
    }

    @Override
    public com.bxm.datapark.facade.Page<AppTicketVo> findAppTicketCount(String datetime, String appKey, Integer scene, String keyword, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {
        List<Object> certificates = new ArrayList();
        ArrayList certificateids = new ArrayList();
        StringBuffer adshops = new StringBuffer("");
        HashMap infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            List<AdvertiserDto> adverList = this.reportCommonService.getAdvertiserByparams(keyword, null);
            certificates = this.infoActivityCertificateService.findCertificateByParams(keyword, adverList, null);
            if (CollectionUtils.isNotEmpty(certificates)) {
                certificates.stream().forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                    adshops.append(infoActivityCertificate.getAdvertiser() + ",");
                });
            } else {
                return new com.bxm.datapark.facade.Page();
            }
        }
        HashMap<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        HashMap<Integer, String> mapAe = new HashMap<Integer, String>(16);
        com.bxm.datapark.facade.Page ticketCountCommons = this.dataparkAppPullerIntegration.getAppTicketCount(datetime, appKey, scene, JSON.toJSONString(certificateids), pageSize, pageNum, sortName, sortType);
        List listTemp = ticketCountCommons.getList();
        if (!CollectionUtils.isNotEmpty((Collection)listTemp)) {
            return new com.bxm.datapark.facade.Page();
        }
        this.reportCommonService.getAdshops(keyword, adshops, listTemp, infoActivityCertificateMap);
        if (adshops != null && StringUtils.isNotEmpty((CharSequence)adshops)) {
            this.reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        com.bxm.datapark.facade.Page page = new com.bxm.datapark.facade.Page();
        this.mapper.map((Object)ticketCountCommons, (Object)page);
        ArrayList<AppTicketVo> ticketCountVoList = new ArrayList<AppTicketVo>();
        if (CollectionUtils.isNotEmpty((Collection)listTemp)) {
            this.integrationAppTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, listTemp, ticketCountVoList);
            page.setList(ticketCountVoList);
        }
        return page;
    }

    @Override
    public List<AppTicketVo> findAppTicketCount(String datetime, String appKey, Integer scene, String keyword) throws IOException {
        List<Object> certificates = new ArrayList();
        ArrayList certificateids = new ArrayList();
        StringBuffer adshops = new StringBuffer("");
        HashMap infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            List<AdvertiserDto> adverList = this.reportCommonService.getAdvertiserByparams(keyword, null);
            certificates = this.infoActivityCertificateService.findCertificateByParams(keyword, adverList, null);
            if (CollectionUtils.isNotEmpty(certificates)) {
                certificates.stream().forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                    adshops.append(infoActivityCertificate.getAdvertiser() + ",");
                });
            } else {
                return new ArrayList<AppTicketVo>();
            }
        }
        HashMap<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        HashMap<Integer, String> mapAe = new HashMap<Integer, String>(16);
        List ticketCountCommons = this.dataparkAppPullerIntegration.getAppTicketCount(datetime, appKey, scene, JSON.toJSONString(certificateids));
        if (!CollectionUtils.isNotEmpty((Collection)ticketCountCommons)) {
            return new ArrayList<AppTicketVo>();
        }
        this.reportCommonService.getAdshops(keyword, adshops, ticketCountCommons, infoActivityCertificateMap);
        if (adshops != null && StringUtils.isNotEmpty((CharSequence)adshops)) {
            this.reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        ArrayList<AppTicketVo> ticketCountVoList = new ArrayList<AppTicketVo>();
        if (CollectionUtils.isNotEmpty((Collection)ticketCountCommons)) {
            this.integrationAppTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, ticketCountCommons, ticketCountVoList);
        }
        return ticketCountVoList;
    }

    private void integrationAppTicketData(Map<Integer, String> mapAdvertiser, Map<Integer, String> mapAe, Map<Long, AdTicket> infoActivityCertificateMap, List<TicketCountCommon> ticketCounts, List<AppTicketVo> ticketCountVoList) {
        ticketCounts.stream().forEach(ticketCountCommon -> {
            AppTicketVo appTicketVo = new AppTicketVo();
            this.mapper.map(ticketCountCommon, (Object)appTicketVo);
            AdTicket infoActivityCertificate = (AdTicket)infoActivityCertificateMap.get(appTicketVo.getCertificateid());
            if (infoActivityCertificate != null) {
                String adshop = infoActivityCertificate.getAdvertiser() + "";
                if (StringUtil.isNotEmpty((CharSequence)adshop)) {
                    appTicketVo.setAdvertiserName((String)mapAdvertiser.get(Integer.valueOf(adshop)));
                    appTicketVo.setAEName((String)mapAe.get(infoActivityCertificate.getId().intValue()));
                }
                appTicketVo.setCertificateName(infoActivityCertificate.getName());
            }
            ticketCountVoList.add(appTicketVo);
        });
    }

    @Override
    public List<AppTicketDateVo> findAppTicketCountDate(String startTime, String endTime, String appKey, Long certificateid, String sortName, String sortType) throws IOException {
        List appCountPage = this.dataparkAppPullerIntegration.getAppTicketCountDate(startTime, endTime, appKey, certificateid, sortName, sortType);
        ArrayList<AppTicketDateVo> appTicketDateVos = new ArrayList<AppTicketDateVo>();
        if (CollectionUtils.isNotEmpty((Collection)appCountPage)) {
            appCountPage.stream().forEach(ticketCountCommon -> {
                AppTicketDateVo appTicketDateVo = new AppTicketDateVo();
                this.mapper.map(ticketCountCommon, (Object)appTicketDateVo);
                appTicketDateVos.add(appTicketDateVo);
            });
        }
        return appTicketDateVos;
    }

    @Override
    public com.bxm.datapark.facade.Page<AppBusinessTicketVo> findAppBusinessTicketCount(String datetime, String appKey, String business, Integer scene, String keyword, Integer pageSize, Integer pageNum, String sortName, String sortType, Integer ticketType) throws IOException {
        List<Object> certificates = new ArrayList();
        ArrayList certificateids = new ArrayList();
        StringBuffer adshops = new StringBuffer("");
        HashMap infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)keyword) || null != ticketType && ticketType > 0) {
            List<AdvertiserDto> adverList = null;
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                adverList = this.reportCommonService.getAdvertiserByparams(keyword, null);
            }
            if (CollectionUtils.isNotEmpty(certificates = this.infoActivityCertificateService.findCertificateByParams(keyword, adverList, ticketType))) {
                certificates.stream().forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                    adshops.append(infoActivityCertificate.getAdvertiser() + ",");
                });
            } else {
                return new com.bxm.datapark.facade.Page();
            }
        }
        HashMap<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        HashMap<Integer, String> mapAe = new HashMap<Integer, String>(16);
        com.bxm.datapark.facade.Page appCountPage = this.dataparkAppPullerIntegration.getAppBusinessTicketCount(datetime, appKey, business, scene, JSON.toJSONString(certificateids), pageSize, pageNum, sortName, sortType);
        List listTemp = appCountPage.getList();
        if (!CollectionUtils.isNotEmpty((Collection)listTemp)) {
            return new com.bxm.datapark.facade.Page();
        }
        this.reportCommonService.getAdshops(keyword, adshops, listTemp, infoActivityCertificateMap);
        if (adshops != null && StringUtils.isNotEmpty((CharSequence)adshops)) {
            this.reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        com.bxm.datapark.facade.Page page = new com.bxm.datapark.facade.Page();
        this.mapper.map((Object)appCountPage, (Object)page);
        ArrayList<AppBusinessTicketVo> ticketCountVoList = new ArrayList<AppBusinessTicketVo>();
        if (CollectionUtils.isNotEmpty((Collection)listTemp)) {
            this.integrationAppBusinessTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, listTemp, ticketCountVoList);
            this.integrationTicketValue(ticketCountVoList, datetime, appKey, business);
            page.setList(ticketCountVoList);
        }
        return page;
    }

    @Override
    public com.bxm.datapark.facade.Page<AppBusinessTicketVo> findAppBusinessTicketCountPageAfterLoadAll(String datetime, String appKey, String business, Integer scene, String keyword, Integer pageSize, Integer pageNum, String sortName, String sortType, Integer ticketType) throws IOException {
        com.bxm.datapark.facade.Page<AppBusinessTicketVo> appBusinessTicketCount = this.findAppBusinessTicketCount(datetime, appKey, business, scene, keyword, Integer.MAX_VALUE, 1, sortName, sortType, ticketType);
        List allVos = Lists.newArrayList();
        if (null != appBusinessTicketCount && CollectionUtils.isNotEmpty((Collection)appBusinessTicketCount.getList())) {
            allVos = appBusinessTicketCount.getList();
        }
        com.bxm.datapark.facade.Page page = new com.bxm.datapark.facade.Page();
        if (CollectionUtils.isNotEmpty((Collection)allVos)) {
            AppBusinessTicketVo sum = (AppBusinessTicketVo)allVos.remove(0);
            page.setPageNum(pageNum);
            page.setPageSize(pageSize);
            page.setTotal(Long.valueOf(allVos.size()));
            SortUtils.sort(allVos, sortName, sortType);
            ArrayList<Object> returnPageList = new ArrayList<Object>();
            returnPageList.add(sum);
            returnPageList.addAll(ListUtil.getTotalPage(allVos, allVos.size(), pageNum, pageSize));
            page.setList(returnPageList);
        }
        return page;
    }

    private void integrationTicketValue(List<AppBusinessTicketVo> ticketCountVoList, String datetime, String appKey, String business) {
        ArrayList certificateIds = Lists.newArrayList();
        ticketCountVoList.forEach(appBusinessTicketVo -> certificateIds.add(appBusinessTicketVo.getCertificateid()));
        List adTicketList = this.adTicketMapper.findAllByIds((List)certificateIds);
        HashMap adTicketMap = Maps.newHashMap();
        adTicketList.forEach(adTicket -> adTicketMap.put(adTicket.getId(), adTicket));
        List adTicketOcpcConfList = this.adTicketOcpcMapper.selectByTicketIdList((List)certificateIds);
        HashMap adTicketOcpcMap = Maps.newHashMap();
        adTicketOcpcConfList.forEach(adTicketOcpcConf -> adTicketOcpcMap.put(adTicketOcpcConf.getTicketId(), adTicketOcpcConf));
        for (AppBusinessTicketVo appBusinessTicketVo2 : ticketCountVoList) {
            this.appendTicketInfo(datetime, appKey, business, adTicketMap, adTicketOcpcMap, appBusinessTicketVo2);
        }
    }

    private void appendTicketInfo(String datetime, String appKey, String business, Map<Long, AdTicket> adTicketMap, Map<Long, AdTicketOcpcConf> adTicketOcpcMap, AppBusinessTicketVo appBusinessTicketVo) {
        AdTicketFlowPackageConf adTicketFlowPackageConf;
        JSONObject groupObject;
        String groupId;
        Long ticketId = appBusinessTicketVo.getCertificateid();
        if (ticketId == null) {
            return;
        }
        AdTicket adTicket = adTicketMap.get(ticketId);
        AdTicketOcpcConf adTicketOcpcConf = adTicketOcpcMap.get(ticketId);
        if (adTicket != null) {
            boolean supportOcpc;
            short settleType = adTicket.getSettleType();
            boolean bl = adTicketOcpcConf == null ? false : (supportOcpc = adTicketOcpcConf.getIsSupportOcpc() == 1);
            if (settleType == 1 && supportOcpc) {
                appBusinessTicketVo.setSettleType("OCPC");
            } else if (settleType == 1 && !supportOcpc) {
                appBusinessTicketVo.setSettleType("CPC");
            } else if (settleType == 2) {
                appBusinessTicketVo.setSettleType("CPA");
            }
            appBusinessTicketVo.setPackagePrice(new BigDecimal(adTicket.getPrice()).divide(new BigDecimal(1000), 2, 5));
        }
        String positionId = appKey + (StringUtils.isEmpty((CharSequence)business) ? "" : business.replaceAll("ad", ""));
        String positonGoup = (String)this.fetcher.hfetch(TicketKeyGenerator.Filter.getPositionGroup((BigInteger)new BigInteger(String.valueOf(ticketId))), positionId, String.class);
        if (StringUtils.isNotEmpty((CharSequence)positonGoup) && StringUtils.isNotEmpty((CharSequence)(groupId = (groupObject = JSONObject.parseObject((String)positonGoup)).getString("groupId"))) && (adTicketFlowPackageConf = this.adTicketFlowPackageMapper.selectPackageById(groupId)) != null) {
            appBusinessTicketVo.setPackageName(adTicketFlowPackageConf.getPackageName());
            try {
                BigDecimal price = groupObject.getBigDecimal("price");
                appBusinessTicketVo.setPackagePrice(price.divide(new BigDecimal(1000), 2, 5));
            }
            catch (Exception e) {
                this.logger.error("\u51fa\u4ef7\u7c7b\u578b\u8f6c\u6362\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)appBusinessTicketVo.getDatetime())) {
                appBusinessTicketVo.setTicketOperationLog(Integer.valueOf(this.getTicketLogSize(appBusinessTicketVo.getDatetime(), ticketId)));
            } else {
                appBusinessTicketVo.setTicketOperationLog(Integer.valueOf(this.getTicketLogSize(datetime, ticketId)));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u793c\u5238\u7684\u5238\u64cd\u4f5c\u65e5\u5fd7\u6761\u6570\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    private int getTicketLogSize(String datetime, Long ticketId) {
        long dateTimeStamp = DateFormatUtil.getMillisecondByDate(datetime);
        long dateTimePlusOneDayStamp = DateFormatUtil.getMillisecondByPlusDate(datetime, 1L);
        long pageSize = this.getPageTotal(dateTimeStamp, dateTimePlusOneDayStamp, ticketId);
        return (int)pageSize;
    }

    private long getPageTotal(long dateTimeStamp, long dateTimePlusOneDayStamp, Object ticketId) {
        LogModelDto dto = new LogModelDto();
        dto.setPageNum(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(1));
        dto.setStartDateTime(Long.valueOf(dateTimeStamp));
        dto.setEndDateTime(Long.valueOf(dateTimePlusOneDayStamp));
        dto.setAdticketId(String.valueOf(ticketId));
        dto.setCollectionName("logs_adsmanager");
        Page logModelPage = this.logsService.find(dto);
        return logModelPage.getTotal();
    }

    @Override
    public List<AppBusinessTicketVo> findAppBusinessTicketExport(String datetime, String appKey, String business, Integer scene, String keyword, Integer ticketType) throws IOException {
        List<Object> certificates = new ArrayList();
        ArrayList certificateids = new ArrayList();
        StringBuffer adshops = new StringBuffer("");
        HashMap infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            List<AdvertiserDto> adverList = this.reportCommonService.getAdvertiserByparams(keyword, null);
            certificates = this.infoActivityCertificateService.findCertificateByParams(keyword, adverList, ticketType);
            certificates = this.infoActivityCertificateService.findCertificateByKeyword(keyword);
            if (CollectionUtils.isNotEmpty(certificates)) {
                certificates.stream().forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                    adshops.append(infoActivityCertificate.getAdvertiser() + ",");
                });
            } else {
                return new ArrayList<AppBusinessTicketVo>();
            }
        }
        HashMap<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        HashMap<Integer, String> mapAe = new HashMap<Integer, String>(16);
        List ticketCounts = this.dataparkAppPullerIntegration.getAppBusinessTicketExport(datetime, appKey, business, scene, JSON.toJSONString(certificateids));
        if (!CollectionUtils.isNotEmpty((Collection)ticketCounts)) {
            return new ArrayList<AppBusinessTicketVo>();
        }
        this.reportCommonService.getAdshops(keyword, adshops, ticketCounts, infoActivityCertificateMap);
        if (adshops != null && StringUtils.isNotEmpty((CharSequence)adshops)) {
            this.reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        ArrayList<AppBusinessTicketVo> ticketCountVoList = new ArrayList<AppBusinessTicketVo>();
        if (CollectionUtils.isNotEmpty((Collection)ticketCounts)) {
            this.integrationAppBusinessTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, ticketCounts, ticketCountVoList);
        }
        return ticketCountVoList;
    }

    private void integrationAppBusinessTicketData(Map<Integer, String> mapAdvertiser, Map<Integer, String> mapAe, Map<Long, AdTicket> infoActivityCertificateMap, List<TicketCountCommon> ticketCounts, List<AppBusinessTicketVo> ticketCountVoList) {
        ticketCounts.stream().forEach(ticketCountCommon -> {
            AppBusinessTicketVo appTicketVo = new AppBusinessTicketVo();
            this.mapper.map(ticketCountCommon, (Object)appTicketVo);
            AdTicket infoActivityCertificate = (AdTicket)infoActivityCertificateMap.get(appTicketVo.getCertificateid());
            if (infoActivityCertificate != null) {
                String adshop = infoActivityCertificate.getAdvertiser() + "";
                if (StringUtil.isNotEmpty((CharSequence)adshop)) {
                    appTicketVo.setAdvertiserName((String)mapAdvertiser.get(Integer.valueOf(adshop)));
                    appTicketVo.setAEName((String)mapAe.get(infoActivityCertificate.getId().intValue()));
                }
                appTicketVo.setCertificateName(infoActivityCertificate.getName());
            }
            ticketCountVoList.add(appTicketVo);
        });
    }

    @Override
    public ResultModel findAppBusinessActivity(String json, String datetime, String appKey, String business, String activityType, String activityPlanner, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {
        List<Long> activity = new ArrayList();
        ResultModel resultModel = new ResultModel();
        if (!StringUtils.isEmpty((CharSequence)json)) {
            HashMap<String, String> parm = new HashMap<String, String>();
            parm.put("activityname", json);
            activity = this.activityMapper.findListByKeywordsNew(parm);
            if (CollectionUtils.isEmpty(activity)) {
                Pagination pagination = new Pagination();
                pagination.setPageNo(pageNum);
                pagination.setPageSize(pageNum);
                resultModel.setReturnValue((Object)pagination);
                return resultModel;
            }
        }
        resultModel = this.dataparkAppPullerIntegration.appBusinessActivity(JSON.toJSONString(activity), datetime, appKey, business, activityType, activityPlanner, pageSize, pageNum, sortName, sortType);
        List activityWithBLOBs = new ArrayList();
        Pagination pagination = (Pagination)resultModel.getReturnValue();
        if (pagination == null) {
            pagination = new Pagination(pageNum.intValue(), pageSize.intValue(), 0);
            resultModel.setReturnValue((Object)pagination);
            return resultModel;
        }
        List activityCounts = pagination.getList();
        if (CollectionUtils.isEmpty((Collection)activityCounts)) {
            return resultModel;
        }
        for (ActivityCount activityCount : activityCounts) {
            if (activityCount.getActivityId() == null) continue;
            activity.add(activityCount.getActivityId());
        }
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("ids", activity);
        activityWithBLOBs = this.activityMapper.findList(map);
        HashMap<String, ActivityWithBLOBs> activityWithBLOBsMap = new HashMap<String, ActivityWithBLOBs>();
        for (ActivityWithBLOBs activityWithBLOBs1 : activityWithBLOBs) {
            activityWithBLOBsMap.put(activityWithBLOBs1.getId().toString(), activityWithBLOBs1);
        }
        ArrayList<ActivityVo> activityVos = new ArrayList<ActivityVo>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityVo activityVo = new ActivityVo();
            this.mapper.map((Object)activityCount, (Object)activityVo);
            String activityName = activityWithBLOBsMap.getOrDefault(activityCount.getActivityId() + "", new ActivityWithBLOBs()).getActivityName();
            activityVo.setActivityName(StringUtils.isEmpty((CharSequence)activityName) ? "" : activityName);
            activityVo.setActivityModelName(activityCount.getActivityType());
            Double perClickPv = activityCount.getPerClickPv() == null ? 0.0 : activityCount.getPerClickPv();
            activityVo.setPerClickPv(perClickPv);
            activityVo.setPerClickPvChange(this.getPerChangeName(activityCount));
            activityVos.add(activityVo);
        }
        pagination.setList(activityVos);
        resultModel.setReturnValue((Object)pagination);
        return resultModel;
    }

    @Override
    public List<ActivityVo> appBusinessActivityExport(String datetime, String appKey, String business, String keyword) throws IOException {
        HashMap map;
        List<Long> activity = new ArrayList();
        if (!StringUtils.isEmpty((CharSequence)keyword)) {
            HashMap<String, String> parm = new HashMap<String, String>();
            parm.put("activityname", keyword);
            activity = this.activityMapper.findListByKeywordsNew(parm);
        }
        List activityCounts = this.dataparkAppPullerIntegration.appBusinessActivityExport(JSON.toJSONString(activity), datetime, appKey, business);
        List activityWithBLOBs = new ArrayList();
        if (activity.size() > 0) {
            map = new HashMap();
            map.put("ids", activity);
            activityWithBLOBs = this.activityMapper.findList(map);
        } else {
            for (Object activityCount : activityCounts) {
                if (activityCount.getActivityId() == null) continue;
                activity.add(activityCount.getActivityId());
            }
            map = new HashMap();
            map.put("ids", activity);
            activityWithBLOBs = this.activityMapper.findList(map);
        }
        HashMap<String, ActivityWithBLOBs> activityWithBLOBsMap = new HashMap<String, ActivityWithBLOBs>();
        for (ActivityWithBLOBs activityWithBLOBs1 : activityWithBLOBs) {
            activityWithBLOBsMap.put(activityWithBLOBs1.getId() + "", activityWithBLOBs1);
        }
        ArrayList<ActivityVo> activityVos = new ArrayList<ActivityVo>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityVo activityVo = new ActivityVo();
            this.mapper.map((Object)activityCount, (Object)activityVo);
            ActivityWithBLOBs activityWithBLOBs1 = activityWithBLOBsMap.getOrDefault(activityCount.getActivityId() + "", new ActivityWithBLOBs());
            String activityName = activityWithBLOBs1.getActivityName();
            String activityType = activityWithBLOBs1.getActivityType();
            Dictionaries dictionaries = this.dictionariesService.findByCode(StringUtils.isEmpty((CharSequence)activityType) ? "" : activityType, "acttype");
            if (dictionaries != null) {
                activityVo.setActivityModelName(dictionaries.getTypename());
            }
            activityVo.setActivityName(activityName);
            activityVos.add(activityVo);
        }
        return activityVos;
    }

    private List<AppBusinessVo> getUpdateList(List<AppCount> listPre, List<AppBusinessVo> list, String datetime, String appKey, Long total, Integer size) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("datetime", datetime);
        map.put("appKey", appKey);
        List updateList = this.tblAdIconClickPvUpdateMapperExt.findByDateAndAppkey(map);
        HashMap mapTemp = new HashMap();
        updateList.forEach(tblAdIconClickPvUpdate -> mapTemp.put(tblAdIconClickPvUpdate.getBusiness(), tblAdIconClickPvUpdate));
        HashMap mapPre = new HashMap();
        if (listPre == null || listPre.size() == 0) {
            ArrayList listTemp = new ArrayList();
            AppCount appCountTemp = new AppCount();
            appCountTemp.setIconPv(Integer.valueOf(0));
            appCountTemp.setEcpm(Double.valueOf(0.0));
            appCountTemp.setmEcpm(Double.valueOf(0.0));
            appCountTemp.setIconPv(Integer.valueOf(0));
            appCountTemp.setMidPageRate(Double.valueOf(0.0));
            listTemp.add(appCountTemp);
            listTemp.forEach(appCount -> mapPre.put(appCount.getBusiness(), appCount));
        } else {
            listPre.forEach(appCount -> mapPre.put(appCount.getBusiness(), appCount));
        }
        for (AppBusinessVo appBusinessVo : list) {
            Integer dockMethod;
            for (String key : mapTemp.keySet()) {
                if (!key.equals(appBusinessVo.getBusiness())) continue;
                int iconPv = 0;
                if (mapTemp.get(key) != null && null != ((TblAdIconClickPvUpdate)mapTemp.get(key)).getIconPv()) {
                    iconPv = ((TblAdIconClickPvUpdate)mapTemp.get(key)).getIconPv();
                }
                int iconClickPv = 0;
                if (mapTemp.get(key) != null && null != ((TblAdIconClickPvUpdate)mapTemp.get(key)).getIconClickPv()) {
                    iconClickPv = ((TblAdIconClickPvUpdate)mapTemp.get(key)).getIconClickPv();
                }
                if (iconPv != 0 && iconClickPv == 0) {
                    appBusinessVo.setIconPv(Integer.valueOf(iconPv));
                    appBusinessVo.setEcpm(DateParkUtil.getArpuOrEcpm(appBusinessVo.getIncome(), (Integer)iconPv));
                    appBusinessVo.setmEcpm(DateParkUtil.getArpuOrEcpm(appBusinessVo.getBusinessIncome(), (Integer)iconPv));
                    for (String business : mapPre.keySet()) {
                        if (!key.equals(appBusinessVo.getBusiness())) continue;
                        appBusinessVo.setIconChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getIconPv(), iconPv));
                        appBusinessVo.setEcpmChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getEcpm(), appBusinessVo.getEcpm()));
                        appBusinessVo.setmEcpmChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getmEcpm(), appBusinessVo.getmEcpm()));
                    }
                    continue;
                }
                if (iconPv == 0 && iconClickPv != 0) {
                    appBusinessVo.setIconClickPv(Integer.valueOf(iconClickPv));
                    appBusinessVo.setMidPageRate(DateParkUtil.getArpuOrEcpm(appBusinessVo.getMidPagePv().toString(), (Integer)iconClickPv));
                    for (String business : mapPre.keySet()) {
                        if (!key.equals(appBusinessVo.getBusiness())) continue;
                        appBusinessVo.setIconClickChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getIconClickPv(), iconClickPv));
                        appBusinessVo.setMidPageRateChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getMidPageRate(), appBusinessVo.getMidPageRate()));
                    }
                    continue;
                }
                if (iconPv == 0 || iconClickPv == 0) continue;
                appBusinessVo.setIconPv(Integer.valueOf(iconPv));
                appBusinessVo.setIconClickPv(Integer.valueOf(iconClickPv));
                appBusinessVo.setEcpm(DateParkUtil.getArpuOrEcpm(appBusinessVo.getIncome(), (Integer)iconPv));
                appBusinessVo.setmEcpm(DateParkUtil.getArpuOrEcpm(appBusinessVo.getBusinessIncome(), (Integer)iconPv));
                appBusinessVo.setMidPageRate(DateParkUtil.getArpuOrEcpm(appBusinessVo.getMidPagePv().toString(), (Integer)iconClickPv));
                for (String business : mapPre.keySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)business) || !business.equals(appBusinessVo.getBusiness())) continue;
                    appBusinessVo.setIconChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getIconPv(), iconPv));
                    appBusinessVo.setEcpmChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getEcpm(), appBusinessVo.getEcpm()));
                    appBusinessVo.setmEcpmChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getmEcpm(), appBusinessVo.getmEcpm()));
                    appBusinessVo.setIconClickChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getIconClickPv(), iconClickPv));
                    appBusinessVo.setMidPageRateChange(DateParkUtil.dealChange(((AppCount)mapPre.get(business)).getMidPageRate(), appBusinessVo.getMidPageRate()));
                }
            }
            if (StringUtils.isEmpty((CharSequence)appBusinessVo.getAppKey()) || (dockMethod = this.appEntranceFacadeIntegration.queryDockMethod(appBusinessVo.getAppKey(), appBusinessVo.getBusiness().replace("ad-", ""))) == null) continue;
            this.logger.info("dockMethod:{}, iconPv:{}, iconClickPv:{}", new Object[]{dockMethod, appBusinessVo.getIconPv(), appBusinessVo.getIconClickPv()});
            appBusinessVo.setIconPvEditable(Boolean.valueOf(dockMethod == 0 && appBusinessVo.getIconPv() == 0));
            appBusinessVo.setIconClickPvEditable(Boolean.valueOf(dockMethod == 0 && appBusinessVo.getIconClickPv() == 0));
        }
        HashMap mapSum = new HashMap();
        ArrayList<AppBusinessVo> listSum = new ArrayList<AppBusinessVo>();
        for (int i = 1; i <= list.size() - 1; ++i) {
            listSum.add(list.get(i));
        }
        int iconPvSum = 0;
        int iconClickPvSum = 0;
        int midPagePvSum = 0;
        Double incomeSum = 0.0;
        Double businessIncomeSum = 0.0;
        for (int i = 0; i < listSum.size(); ++i) {
            iconPvSum += ((AppBusinessVo)listSum.get(i)).getIconPv().intValue();
            iconClickPvSum += ((AppBusinessVo)listSum.get(i)).getIconClickPv().intValue();
            midPagePvSum += ((AppBusinessVo)listSum.get(i)).getMidPagePv().intValue();
            incomeSum = incomeSum + ((AppBusinessVo)listSum.get(i)).getIncome();
            businessIncomeSum = businessIncomeSum + ((AppBusinessVo)listSum.get(i)).getBusinessIncome();
        }
        Double midPageRateSum = DoubleUtil.formatDouble(midPagePvSum + "", iconClickPvSum + "");
        Double ecpmSum = DateParkUtil.getArpuOrEcpm(incomeSum, (Integer)iconPvSum);
        Double mEcpmSum = DateParkUtil.getArpuOrEcpm(businessIncomeSum, (Integer)iconPvSum);
        list.get(0).setIconPv(Integer.valueOf(iconPvSum));
        list.get(0).setIconClickPv(Integer.valueOf(iconClickPvSum));
        list.get(0).setMidPageRate(midPageRateSum);
        list.get(0).setEcpm(ecpmSum);
        list.get(0).setmEcpm(mEcpmSum);
        if (total > (long)size.intValue()) {
            Integer kong = null;
            list.get(0).setIconPv(kong);
            list.get(0).setIconClickPv(kong);
            list.get(0).setMidPageRate(null);
            list.get(0).setEcpm(null);
            list.get(0).setmEcpm(null);
        }
        if (list == null) {
            return new ArrayList<AppBusinessVo>();
        }
        return list;
    }

    @Override
    public int updateIconOrClickPv(int iconPv, int iconClickPv, String dateTime, String business, String appKey) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dateTime", dateTime);
        map.put("appKey", appKey);
        map.put("business", business);
        TblAdIconClickPvUpdate tblAdIconClickPvUpdate = this.tblAdIconClickPvUpdateMapperExt.findOne(map);
        if (tblAdIconClickPvUpdate != null) {
            if (tblAdIconClickPvUpdate.getIconClickPv() == 0) {
                tblAdIconClickPvUpdate.setIconClickPv(iconClickPv == 0 ? null : Integer.valueOf(iconClickPv));
            }
            if (tblAdIconClickPvUpdate.getIconPv() == 0) {
                tblAdIconClickPvUpdate.setIconPv(iconPv == 0 ? null : Integer.valueOf(iconPv));
            }
            return this.tblAdIconClickPvUpdateMapper.updateByPrimaryKeySelective(tblAdIconClickPvUpdate);
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        TblAdIconClickPvUpdate tblAdIconClickPvUpdateNew = new TblAdIconClickPvUpdate();
        tblAdIconClickPvUpdateNew.setBusiness(business);
        tblAdIconClickPvUpdateNew.setAppkey(appKey);
        tblAdIconClickPvUpdateNew.setDateTime(sf.parse(dateTime));
        tblAdIconClickPvUpdateNew.setIconPv(Integer.valueOf(iconPv));
        tblAdIconClickPvUpdateNew.setIconClickPv(Integer.valueOf(iconClickPv));
        tblAdIconClickPvUpdateNew.setUpdateTime(new Date());
        return this.tblAdIconClickPvUpdateMapper.insert(tblAdIconClickPvUpdateNew);
    }

    @Override
    public List<AppCountVo> findAppCountSumByDate(String startTime, String endTime, String keyword, User user, String sortName, String sortType) throws Exception {
        List appCountVos;
        String roleCode = this.getRoleCode(user);
        ArrayList appCountVoList = new ArrayList();
        List<Object> infoAppMsgs = new ArrayList();
        ArrayList appKeysList = Lists.newArrayList();
        HashMap infoAppMsgMap = Maps.newHashMap();
        StringBuffer appKeys = new StringBuffer();
        if (StringUtils.isNotEmpty((CharSequence)keyword) || StringUtils.isNotEmpty((CharSequence)roleCode)) {
            infoAppMsgs = this.infoAppMsgService.findAllAppkeys(keyword, roleCode);
            if (CollectionUtils.isNotEmpty(infoAppMsgs)) {
                infoAppMsgs.stream().forEach(infoAppMsg -> {
                    appKeysList.add(infoAppMsg.getAppkey());
                    infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                    appKeys.append(infoAppMsg.getAppkey() + ",");
                });
            } else {
                return new ArrayList<AppCountVo>();
            }
        }
        if (CollectionUtils.isEmpty((Collection)(appCountVos = this.dataparkAppPullerIntegration.getAppCountVosSum(startTime, endTime, sortName, sortType, JSON.toJSONString((Object)appKeysList))))) {
            return new ArrayList<AppCountVo>();
        }
        ArrayList<AppCountVo> list = new ArrayList<AppCountVo>();
        this.copyList(appCountVos, list);
        return list;
    }

    @Override
    public List<AppCountVo> appCountSumByDateExport(String startTime, String endTime, String keyword, User user) throws Exception {
        String roleCode = this.getRoleCode(user);
        List<Object> infoAppMsgs = new ArrayList();
        ArrayList appKeysList = Lists.newArrayList();
        HashMap infoAppMsgMap = Maps.newHashMap();
        infoAppMsgs = this.infoAppMsgService.findAllAppkeys(keyword, roleCode);
        if (!CollectionUtils.isNotEmpty(infoAppMsgs)) {
            return new ArrayList<AppCountVo>();
        }
        infoAppMsgs.stream().forEach(infoAppMsg -> {
            appKeysList.add(infoAppMsg.getAppkey());
            infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
        });
        List appCountVos = this.dataparkAppPullerIntegration.appCountVosSumExport(startTime, endTime, JSON.toJSONString((Object)appKeysList));
        if (CollectionUtils.isEmpty((Collection)appCountVos)) {
            return new ArrayList<AppCountVo>();
        }
        ArrayList<AppCountVo> list = new ArrayList<AppCountVo>();
        this.copyList(appCountVos, list);
        if (user.getRoleCodes().contains(RoleEnum.BD.getCode()) && !user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode())) {
            for (int i = 0; i < list.size(); ++i) {
                ((AppCount)appCountVos.get(i)).setMidPagePv(Integer.valueOf(0));
                ((AppCount)appCountVos.get(i)).setMidPvChange("");
                ((AppCount)appCountVos.get(i)).setIndexPv(Integer.valueOf(0));
                ((AppCount)appCountVos.get(i)).setIndexPvChange("");
                ((AppCount)appCountVos.get(i)).setIndexUv(Integer.valueOf(0));
                ((AppCount)appCountVos.get(i)).setIndexUvChange("");
                ((AppCount)appCountVos.get(i)).setIncome(Double.valueOf(0.0));
                ((AppCount)appCountVos.get(i)).setIncomeChange("");
                ((AppCount)appCountVos.get(i)).setDeveloperIncome(Double.valueOf(0.0));
                ((AppCount)appCountVos.get(i)).setDeveloperIncomeChange("");
                ((AppCount)appCountVos.get(i)).setBxmIncome(Double.valueOf(0.0));
                ((AppCount)appCountVos.get(i)).setBxmIncomeChange("");
                ((AppCount)appCountVos.get(i)).setOpenPvAurp(Double.valueOf(0.0));
                ((AppCount)appCountVos.get(i)).setOpenPvAurpChange("");
                ((AppCount)appCountVos.get(i)).setUvAurp(Double.valueOf(0.0));
                ((AppCount)appCountVos.get(i)).setUvAurpChange("");
                ((AppCount)appCountVos.get(i)).setDeveloperAurp(Double.valueOf(0.0));
                ((AppCount)appCountVos.get(i)).setDeveloperAurpChange("");
                ((AppCount)appCountVos.get(i)).setBxmAurp(Double.valueOf(0.0));
                ((AppCount)appCountVos.get(i)).setBxmAurpChange("");
            }
            return list;
        }
        return list;
    }

    @Override
    public List<AppBusinessTicketDateVo> findAppBusinessTicketDateReport(String startTime, String endTime, String appKey, Long certificateid, String sortName, String sortType, String business) throws IOException {
        List lists = this.dataparkAppPullerIntegration.getAppBusinessTicketDateReport(startTime, endTime, appKey, certificateid, sortName, sortType, business);
        ArrayList<AppBusinessTicketDateVo> returnList = new ArrayList<AppBusinessTicketDateVo>();
        ArrayList<AppBusinessTicketVo> tmpList = new ArrayList<AppBusinessTicketVo>();
        if (CollectionUtils.isNotEmpty((Collection)lists)) {
            AppBusinessTicketVo vo;
            for (TicketCountCommon common : lists) {
                vo = new AppBusinessTicketVo();
                this.mapper.map((Object)common, (Object)vo);
                tmpList.add(vo);
            }
            this.integrationTicketValue(tmpList, null, appKey, business);
            for (AppBusinessTicketVo source : tmpList) {
                vo = new AppBusinessTicketDateVo();
                this.mapper.map((Object)source, (Object)vo);
                returnList.add((AppBusinessTicketDateVo)vo);
            }
        }
        return returnList;
    }

    private String getPerChangeName(AppCount appCount) {
        return appCount.getPerClickPvChange() != null && appCount.getPerClickPvChange() != 0.0 ? appCount.getPerClickPvChange() + "%" : "-";
    }

    private String getPerChangeName(ActivityCount appCount) {
        return appCount.getPerClickPvChange() != null && appCount.getPerClickPvChange() != 0.0 ? appCount.getPerClickPvChange() + "%" : "-";
    }

    private String getRoleCode(User user) {
        String roleCode = "";
        if (!user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode()) && !user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode())) {
            if (user.getRoleCodes().contains(RoleEnum.BD.getCode())) {
                roleCode = user.getUserNameContainRole(RoleEnum.BD.getCode());
            } else if (user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
                roleCode = user.getUserNameContainRole(RoleEnum.MJ.getCode());
            }
        }
        return roleCode;
    }
}

