/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.report.impl;

import com.bxm.dao.dictionary.DictionariesMapper;
import com.bxm.report.facade.acl.AclUserIntegration;
import com.bxm.report.facade.advertiser.AdShopIntegration;
import com.bxm.report.model.dao.adticket.AdTicket;
import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.dto.advertiser.AdvertiserDto;
import com.bxm.report.service.adkeeper.DictionariesService;
import com.bxm.report.service.adkeeper.InfoActivityCertificateService;
import com.bxm.report.service.report.ReportCommonService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.stereotype.Component;

@Component
@Configurable
public class ReportCommonServiceImpl
implements ReportCommonService {
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private InfoActivityCertificateService infoActivityCertificateService;
    @Autowired
    private DictionariesMapper dictionariesMapper;
    @Resource
    private AclUserIntegration aclUserIntegration;

    @Override
    public void getAdvertiser(String adshops, Map<Integer, String> mapAdvertiser, Map<Integer, String> mapAe) throws IOException {
        List list = this.adShopIntegration.findAdShopMsgs(adshops);
        Map mapAeName = this.aclUserIntegration.queryUserByRoleCode("ae");
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.stream().forEach(advertiserDto -> mapAdvertiser.put(advertiserDto.getId(), advertiserDto.getCompany()));
        }
        if (StringUtils.isNotBlank((CharSequence)adshops)) {
            ArrayList<Long> idList = new ArrayList<Long>();
            for (String id : adshops.split(",")) {
                idList.add(Long.valueOf(id));
            }
            List<AdTicket> tickets = this.infoActivityCertificateService.findCertificateByAdvertiser(idList);
            if (CollectionUtils.isNotEmpty(tickets)) {
                tickets.stream().forEach(adTicket -> {
                    Integer id = adTicket.getId().intValue();
                    String aeName = (String)mapAeName.get(adTicket.getAe());
                    mapAe.put(id, aeName);
                });
            }
        }
    }

    @Override
    public void getAdshops(String keyword, StringBuffer adshops, List<TicketCountCommon> ticketCounts, Map<Long, AdTicket> infoActivityCertificateMap) {
        StringBuffer dataparkCertificateids = new StringBuffer();
        if (StringUtils.isEmpty((CharSequence)keyword)) {
            ticketCounts.stream().forEach(ticketCountCommon -> dataparkCertificateids.append(ticketCountCommon.getCertificateid() + ","));
            List<AdTicket> certificateInfoByCertificates = this.infoActivityCertificateService.findCertificateInfoByCertificates(dataparkCertificateids);
            if (CollectionUtils.isNotEmpty(certificateInfoByCertificates)) {
                certificateInfoByCertificates.stream().forEach(certificate -> {
                    infoActivityCertificateMap.put(certificate.getId(), (AdTicket)certificate);
                    adshops.append(certificate.getAdvertiser() + ",");
                });
            }
        }
    }

    @Override
    public List<AdvertiserDto> getAdvertiserByparams(String keywords, String aeCode) throws IOException {
        StringBuffer sb = new StringBuffer("");
        if (StringUtils.isNotBlank((CharSequence)aeCode)) {
            sb.append(aeCode);
            return this.adShopIntegration.findAdShopMsgsByKeywordsAndAe(keywords, sb.toString());
        }
        List aeList = this.dictionariesMapper.findByKeywords("ae", keywords);
        if (CollectionUtils.isNotEmpty((Collection)aeList)) {
            aeList.stream().forEach(ae -> sb.append(ae.getTypecode() + ","));
        }
        return this.adShopIntegration.findAdShopMsgsByKeywords(keywords, sb.toString());
    }
}

