/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.facade.Page;
import com.bxm.report.facade.datapark.DataparkTicketPullerIntegration;
import com.bxm.report.model.dao.adticket.AdTicket;
import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.dao.app.InfoAppMsg;
import com.bxm.report.model.dto.advertiser.AdvertiserDto;
import com.bxm.report.model.vo.adposition.AdpositionVo;
import com.bxm.report.model.vo.ticket.TicketAppBusinessVo;
import com.bxm.report.model.vo.ticket.TicketAppVo;
import com.bxm.report.model.vo.ticket.TicketCountVo;
import com.bxm.report.model.vo.ticket.TicketDateVo;
import com.bxm.report.service.adkeeper.AdPositionService;
import com.bxm.report.service.adkeeper.InfoActivityCertificateService;
import com.bxm.report.service.adkeeper.InfoAppMsgService;
import com.bxm.report.service.report.AdTicketTagConfService;
import com.bxm.report.service.report.ITicketReportService;
import com.bxm.report.service.report.ReportCommonService;
import com.bxm.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketReportServiceImpl
implements ITicketReportService {
    private static final Logger logger = LoggerFactory.getLogger(TicketReportServiceImpl.class);
    @Autowired
    private DataparkTicketPullerIntegration dataParkTicketPullerIntegration;
    @Autowired
    private InfoAppMsgService infoAppMsgService;
    @Autowired
    private AdPositionService adPositionService;
    @Autowired
    private InfoActivityCertificateService infoActivityCertificateService;
    @Autowired
    private ReportCommonService reportCommonService;
    @Autowired
    private AdTicketTagConfService adTicketTagConfService;
    @Autowired
    private Mapper mapper;

    @Override
    public Page<TicketCountVo> findTicketCount(String datetime, Integer scene, String keyword, Integer pageNum, Integer pageSize, String sortName, String sortType, String ae, Integer ticketType, Integer tagCode) throws IOException {
        List<Object> certificates = new ArrayList();
        ArrayList<Long> certificateIds = new ArrayList<Long>();
        StringBuffer adShopStr = new StringBuffer("");
        HashSet adshopsSet = new HashSet();
        HashMap infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)keyword) || StringUtils.isNotEmpty((CharSequence)ae) || null != ticketType && ticketType > 0) {
            keyword = keyword.replace(" ", "");
            List<AdvertiserDto> adverList = null;
            String aeNew = ae;
            ae = null;
            if (StringUtils.isNotEmpty((CharSequence)keyword) || StringUtils.isNotEmpty((CharSequence)ae)) {
                adverList = this.reportCommonService.getAdvertiserByparams(keyword, ae);
            }
            if (CollectionUtils.isNotEmpty(certificates = this.infoActivityCertificateService.findCertificateByParamsAndAe(keyword, adverList, ticketType, aeNew))) {
                certificates.stream().forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateIds.add(infoActivityCertificate.getId());
                    adshopsSet.add(infoActivityCertificate.getAdvertiser());
                });
                adshopsSet.stream().forEach(adshop -> adShopStr.append(adshop + ","));
            } else {
                return new Page();
            }
        }
        logger.info("\u5e7f\u544a\u7c7b\u578b\u8fc7\u6ee4\u524d\uff1a" + JSON.toJSONString(certificateIds));
        if (null != tagCode) {
            List<Long> ticketIds;
            if (CollectionUtils.isEmpty(certificateIds)) {
                ticketIds = this.adTicketTagConfService.findTicketIdsByOneLevelTagCode(tagCode);
                if (CollectionUtils.isEmpty(ticketIds)) {
                    return new Page();
                }
                certificateIds.addAll(ticketIds);
            } else {
                ticketIds = this.adTicketTagConfService.checkTicketBelongOneLevelTagCode(certificateIds, tagCode);
                if (CollectionUtils.isEmpty(ticketIds)) {
                    return new Page();
                }
                certificateIds.removeIf(ticketId -> !ticketIds.contains(ticketId));
            }
        }
        logger.info("\u5e7f\u544a\u7c7b\u578b\u8fc7\u6ee4\u540e\uff1a" + JSON.toJSONString(certificateIds));
        HashMap<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        HashMap<Integer, String> mapAe = new HashMap<Integer, String>(16);
        Page ticketCountCommonPage = this.dataParkTicketPullerIntegration.getTicketCount(datetime, scene, JSON.toJSONString(certificateIds), pageNum, pageSize, sortName, sortType);
        List listTemp = ticketCountCommonPage.getList();
        if (!CollectionUtils.isNotEmpty((Collection)listTemp)) {
            return new Page();
        }
        this.reportCommonService.getAdshops(keyword, adShopStr, listTemp, infoActivityCertificateMap);
        if (StringUtils.isNotBlank((CharSequence)adShopStr.toString())) {
            this.reportCommonService.getAdvertiser(adShopStr.toString(), mapAdvertiser, mapAe);
        }
        Page page = new Page();
        this.mapper.map((Object)ticketCountCommonPage, (Object)page);
        ArrayList<TicketCountVo> ticketCountVoList = new ArrayList<TicketCountVo>();
        if (CollectionUtils.isNotEmpty((Collection)listTemp)) {
            this.integrationTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, listTemp, ticketCountVoList);
            page.setList(ticketCountVoList);
        }
        List<Long> ticketIds = ticketCountVoList.stream().map(TicketCountVo::getCertificateid).collect(Collectors.toList());
        Map<Long, String> tagNameMap = this.adTicketTagConfService.findClassifyTagName(ticketIds);
        for (TicketCountVo ticketCountVo : ticketCountVoList) {
            ticketCountVo.setTagName(tagNameMap.get(ticketCountVo.getCertificateid()));
        }
        return page;
    }

    @Override
    public List<TicketCountVo> findTicketCountExport(String datetime, Integer scene, String keyword, String ae, Integer ticketType, Integer tagCode) throws IOException {
        List<Object> certificates = new ArrayList();
        ArrayList<Long> certificateids = new ArrayList<Long>();
        StringBuffer adshops = new StringBuffer("");
        HashMap infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)keyword) || StringUtils.isNotEmpty((CharSequence)ae) || null != ticketType && ticketType > 0) {
            List<AdvertiserDto> adverList = null;
            String aeNew = ae;
            ae = null;
            if (StringUtils.isNotEmpty((CharSequence)keyword) || StringUtils.isNotEmpty((CharSequence)ae)) {
                adverList = this.reportCommonService.getAdvertiserByparams(keyword, ae);
            }
            if (CollectionUtils.isNotEmpty(certificates = this.infoActivityCertificateService.findCertificateByParamsAndAe(keyword, adverList, ticketType, aeNew))) {
                certificates.stream().forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                    adshops.append(infoActivityCertificate.getAdvertiser() + ",");
                });
            } else {
                return new ArrayList<TicketCountVo>();
            }
        }
        if (null != tagCode) {
            List<Long> ticketIds;
            if (CollectionUtils.isEmpty(certificateids)) {
                ticketIds = this.adTicketTagConfService.findTicketIdsByOneLevelTagCode(tagCode);
                if (CollectionUtils.isEmpty(ticketIds)) {
                    return Collections.emptyList();
                }
                certificateids.addAll(ticketIds);
            } else {
                ticketIds = this.adTicketTagConfService.checkTicketBelongOneLevelTagCode(certificateids, tagCode);
                if (CollectionUtils.isEmpty(ticketIds)) {
                    return Collections.emptyList();
                }
                certificateids.removeIf(ticketId -> !ticketIds.contains(ticketId));
            }
        }
        HashMap<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        HashMap<Integer, String> mapAe = new HashMap<Integer, String>(16);
        List ticketCounts = this.dataParkTicketPullerIntegration.getTicketCount(datetime, scene, JSON.toJSONString(certificateids));
        if (!CollectionUtils.isNotEmpty((Collection)ticketCounts)) {
            return new ArrayList<TicketCountVo>();
        }
        this.reportCommonService.getAdshops(keyword, adshops, ticketCounts, infoActivityCertificateMap);
        if (StringUtils.isNotEmpty((CharSequence)adshops.toString())) {
            this.reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        ArrayList<TicketCountVo> ticketCountVoList = new ArrayList<TicketCountVo>();
        if (CollectionUtils.isNotEmpty((Collection)ticketCounts)) {
            this.integrationTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, ticketCounts, ticketCountVoList);
        }
        List<Long> ticketIds = ticketCountVoList.stream().map(TicketCountVo::getCertificateid).collect(Collectors.toList());
        Map<Long, String> tagNameMap = this.adTicketTagConfService.findClassifyTagName(ticketIds);
        for (TicketCountVo ticketCountVo : ticketCountVoList) {
            ticketCountVo.setTagName(tagNameMap.get(ticketCountVo.getCertificateid()));
        }
        return ticketCountVoList;
    }

    private void integrationTicketData(Map<Integer, String> mapAdvertiser, Map<Integer, String> mapAe, Map<Long, AdTicket> infoActivityCertificateMap, List<TicketCountCommon> ticketCounts, List<TicketCountVo> ticketCountVoList) {
        ticketCounts.forEach(ticketCountCommon -> {
            TicketCountVo ticketCountVo = new TicketCountVo();
            this.mapper.map(ticketCountCommon, (Object)ticketCountVo);
            AdTicket infoActivityCertificate = (AdTicket)infoActivityCertificateMap.get(ticketCountVo.getCertificateid());
            if (infoActivityCertificate != null) {
                String adshop = infoActivityCertificate.getAdvertiser() + "";
                if (StringUtil.isNotEmpty((CharSequence)adshop)) {
                    ticketCountVo.setAdvertiserName((String)mapAdvertiser.get(Integer.valueOf(adshop)));
                    ticketCountVo.setAEName((String)mapAe.get(infoActivityCertificate.getId().intValue()));
                }
                ticketCountVo.setCertificateName(infoActivityCertificate.getName());
            }
            ticketCountVoList.add(ticketCountVo);
        });
    }

    @Override
    public Page<TicketAppVo> findTicketAppCount(String datetime, Long certificateid, String keyword, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException {
        Page ticketCountCommonPage;
        List listTemp;
        List<Object> adpositionVos = Lists.newArrayList();
        HashMap infoAppMsgMap = Maps.newHashMap();
        ArrayList appKeyList = Lists.newArrayList();
        StringBuffer appKeys = new StringBuffer("");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            adpositionVos = this.infoAppMsgService.findAllAppkeys(keyword, null);
            if (CollectionUtils.isNotEmpty((Collection)adpositionVos)) {
                adpositionVos.stream().forEach(infoAppMsg -> {
                    appKeyList.add(infoAppMsg.getAppkey());
                    infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                    appKeys.append(infoAppMsg.getAppkey() + ",");
                });
            } else {
                return new Page();
            }
        }
        if (!CollectionUtils.isNotEmpty((Collection)(listTemp = (ticketCountCommonPage = this.dataParkTicketPullerIntegration.getTicketAppCount(datetime, certificateid, JSON.toJSONString((Object)appKeyList), pageNum, pageSize, sortName, sortType)).getList()))) {
            return new Page();
        }
        this.getAppKeys(keyword, infoAppMsgMap, appKeyList, appKeys, listTemp);
        Map<String, Integer> businessNumberMaps = this.adPositionService.getBusinessNumberByAppKeys(appKeyList);
        Page appCountPageRs = new Page();
        this.mapper.map((Object)ticketCountCommonPage, (Object)appCountPageRs);
        ArrayList list = new ArrayList();
        if (appCountPageRs != null && CollectionUtils.isNotEmpty((Collection)listTemp)) {
            listTemp.stream().forEach(ticketCountCommon -> {
                TicketAppVo ticketAppVo = new TicketAppVo();
                this.mapper.map(ticketCountCommon, (Object)ticketAppVo);
                ticketAppVo.setAppKey(ticketCountCommon.getAppkey());
                ticketAppVo.setAppName(infoAppMsgMap.getOrDefault(ticketAppVo.getAppKey(), new InfoAppMsg()).getAppname());
                Integer businessNumber = businessNumberMaps.getOrDefault(ticketCountCommon.getAppkey(), Integer.valueOf("0"));
                ticketAppVo.setBusinessNumber(businessNumber == null ? "" : businessNumber.toString());
                list.add(ticketAppVo);
            });
            appCountPageRs.setList(list);
        }
        return appCountPageRs;
    }

    @Override
    public List<TicketAppVo> findTicketAppCountExport(String datetime, Long certificateid, String keyword) throws IOException {
        List ticketAppCounts;
        List<Object> adpositionVos = Lists.newArrayList();
        HashMap infoAppMsgMap = Maps.newHashMap();
        ArrayList appKeyList = Lists.newArrayList();
        StringBuffer appKeys = new StringBuffer("");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            adpositionVos = this.infoAppMsgService.findAllAppkeys(keyword, null);
            if (CollectionUtils.isNotEmpty((Collection)adpositionVos)) {
                adpositionVos.stream().forEach(infoAppMsg -> {
                    appKeyList.add(infoAppMsg.getAppkey());
                    infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                    appKeys.append(infoAppMsg.getAppkey() + ",");
                });
            } else {
                return new ArrayList<TicketAppVo>();
            }
        }
        if (!CollectionUtils.isNotEmpty((Collection)(ticketAppCounts = this.dataParkTicketPullerIntegration.getTicketAppCount(datetime, certificateid, JSON.toJSONString((Object)appKeyList))))) {
            return new ArrayList<TicketAppVo>();
        }
        this.getAppKeys(keyword, infoAppMsgMap, appKeyList, appKeys, ticketAppCounts);
        Map<String, Integer> businessNumberMaps = this.adPositionService.getBusinessNumberByAppKeys(appKeyList);
        ArrayList<TicketAppVo> ticketAppVos = new ArrayList<TicketAppVo>();
        if (CollectionUtils.isNotEmpty((Collection)ticketAppCounts)) {
            ticketAppCounts.stream().forEach(ticketCountCommon -> {
                TicketAppVo appBusinessVo = new TicketAppVo();
                this.mapper.map(ticketCountCommon, (Object)appBusinessVo);
                appBusinessVo.setAppKey(ticketCountCommon.getAppkey());
                appBusinessVo.setAppName(infoAppMsgMap.getOrDefault(appBusinessVo.getAppKey(), new InfoAppMsg()).getAppname());
                Integer businessNumber = businessNumberMaps.getOrDefault(ticketCountCommon.getAppkey(), Integer.valueOf("0"));
                appBusinessVo.setBusinessNumber(businessNumber == null ? "" : businessNumber.toString());
                ticketAppVos.add(appBusinessVo);
            });
        }
        return ticketAppVos;
    }

    private void getAppKeys(String keyword, Map<String, InfoAppMsg> infoAppMsgMap, List<String> appKeyList, StringBuffer appKeys, List<TicketCountCommon> ticketAppCounts) {
        if (StringUtils.isEmpty((CharSequence)keyword)) {
            ticketAppCounts.stream().forEach(ticketCountCommon -> {
                appKeys.append(ticketCountCommon.getAppkey() + ",");
                appKeyList.add(ticketCountCommon.getAppkey());
            });
            List<InfoAppMsg> infoAppByAppkeys = this.infoAppMsgService.findInfoAppByAppkeys(appKeys);
            if (CollectionUtils.isNotEmpty(infoAppByAppkeys)) {
                infoAppByAppkeys.stream().forEach(infoAppMsg -> infoAppMsgMap.put(infoAppMsg.getAppkey(), (InfoAppMsg)infoAppMsg));
            }
        }
    }

    @Override
    public Page<TicketAppBusinessVo> findTicketAppBusinessCount(String datetime, Long certificateid, String appKey, String keyword, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException {
        Page ticketAppBusinessCount;
        List listTemp;
        List<Object> adpositionVos = Lists.newArrayList();
        ArrayList businesses = Lists.newArrayList();
        HashMap adpositionVoMap = Maps.newHashMap();
        StringBuffer sbBusinesses = new StringBuffer("");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            adpositionVos = this.adPositionService.findBusinesses(appKey, keyword, null, null);
            if (CollectionUtils.isNotEmpty((Collection)adpositionVos)) {
                this.dealBusiness(adpositionVos, businesses, adpositionVoMap, sbBusinesses);
            } else {
                return new Page();
            }
        }
        if (!CollectionUtils.isNotEmpty((Collection)(listTemp = (ticketAppBusinessCount = this.dataParkTicketPullerIntegration.getTicketAppBusinessCount(datetime, certificateid, appKey, JSON.toJSONString((Object)businesses), pageNum, pageSize, sortName, sortType)).getList()))) {
            return new Page();
        }
        this.getBusinesses(appKey, keyword, adpositionVoMap, sbBusinesses, listTemp);
        ArrayList list = new ArrayList();
        Page appBusinessPageRs = new Page();
        this.mapper.map((Object)ticketAppBusinessCount, (Object)appBusinessPageRs);
        if (CollectionUtils.isNotEmpty((Collection)listTemp)) {
            listTemp.stream().forEach(ticketCountCommon -> {
                TicketAppBusinessVo ticketAppBusinessVo = new TicketAppBusinessVo();
                this.mapper.map(ticketCountCommon, (Object)ticketAppBusinessVo);
                if (StringUtils.isNotEmpty((CharSequence)ticketAppBusinessVo.getBusiness())) {
                    ticketAppBusinessVo.setBusinessName(adpositionVoMap.getOrDefault(ticketAppBusinessVo.getBusiness().replaceAll("ad-", ""), new AdpositionVo()).getName());
                }
                list.add(ticketAppBusinessVo);
            });
            appBusinessPageRs.setList(list);
        }
        return appBusinessPageRs;
    }

    @Override
    public List<TicketAppBusinessVo> findTicketAppBusinessCountExport(String datetime, Long certificateid, String appKey, String keyword) throws IOException {
        List ticketCountCommons;
        List<Object> adpositionVos = Lists.newArrayList();
        ArrayList businesses = Lists.newArrayList();
        HashMap adpositionVoMap = Maps.newHashMap();
        StringBuffer sbBusinesses = new StringBuffer("");
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            adpositionVos = this.adPositionService.findBusinesses(appKey, keyword, null, null);
            if (CollectionUtils.isNotEmpty((Collection)adpositionVos)) {
                this.dealBusiness(adpositionVos, businesses, adpositionVoMap, sbBusinesses);
            } else {
                return new ArrayList<TicketAppBusinessVo>();
            }
        }
        if (!CollectionUtils.isNotEmpty((Collection)(ticketCountCommons = this.dataParkTicketPullerIntegration.getTicketAppBusinessCountNew(datetime, certificateid, appKey, JSON.toJSONString((Object)businesses))))) {
            return new ArrayList<TicketAppBusinessVo>();
        }
        this.getBusinesses(appKey, keyword, adpositionVoMap, sbBusinesses, ticketCountCommons);
        ArrayList<TicketAppBusinessVo> appBusinessList = new ArrayList<TicketAppBusinessVo>();
        if (CollectionUtils.isNotEmpty((Collection)ticketCountCommons)) {
            for (TicketCountCommon ticketCountCommon : ticketCountCommons) {
                TicketAppBusinessVo ticketAppBusinessVo = new TicketAppBusinessVo();
                this.mapper.map((Object)ticketCountCommon, (Object)ticketAppBusinessVo);
                if (StringUtils.isNotEmpty((CharSequence)ticketAppBusinessVo.getBusiness())) {
                    ticketAppBusinessVo.setBusinessName(adpositionVoMap.getOrDefault(ticketAppBusinessVo.getBusiness().replaceAll("ad-", ""), new AdpositionVo()).getName());
                }
                appBusinessList.add(ticketAppBusinessVo);
            }
        }
        return appBusinessList;
    }

    private void dealBusiness(List<AdpositionVo> adpositionVos, List<String> businesses, Map<String, AdpositionVo> adpositionVoMap, StringBuffer sbBusinesses) {
        adpositionVos.stream().forEach(adpositionVo -> {
            businesses.add("ad-" + adpositionVo.getBusiness().replaceAll("ad-", ""));
            adpositionVoMap.put(adpositionVo.getBusiness().replaceAll("ad-", ""), (AdpositionVo)adpositionVo);
            sbBusinesses.append(adpositionVo.getBusiness().replaceAll("ad-", "") + ",");
        });
    }

    private void getBusinesses(String appKey, String keyword, Map<String, AdpositionVo> adpositionVoMap, StringBuffer sbBusinesses, List<TicketCountCommon> ticketCountCommons) {
        if (StringUtils.isEmpty((CharSequence)keyword)) {
            ticketCountCommons.stream().forEach(ticketCountCommon -> {
                if (ticketCountCommon.getBusiness() != null) {
                    sbBusinesses.append(ticketCountCommon.getBusiness() + ",");
                }
            });
            List<AdpositionVo> byBusinesses = this.adPositionService.findByBusinesses(appKey, sbBusinesses);
            if (CollectionUtils.isNotEmpty(byBusinesses)) {
                byBusinesses.stream().forEach(adpositionVo -> {
                    if (adpositionVo.getBusiness() != null) {
                        adpositionVoMap.put(adpositionVo.getBusiness().replaceAll("ad-", ""), (AdpositionVo)adpositionVo);
                    }
                });
            }
        }
    }

    @Override
    public List<TicketDateVo> findTicketCountDate(String startTime, String endTime, Long certificateid, String sortName, String sortType) throws IOException {
        List ticketCountCommons = this.dataParkTicketPullerIntegration.getTicketCountDate(startTime, endTime, certificateid, sortName, sortType);
        ArrayList<TicketDateVo> ticketDateVos = new ArrayList<TicketDateVo>();
        if (CollectionUtils.isNotEmpty((Collection)ticketCountCommons)) {
            ticketCountCommons.stream().forEach(ticketCountCommon -> {
                TicketDateVo ticketDateVo = new TicketDateVo();
                this.mapper.map(ticketCountCommon, (Object)ticketDateVo);
                ticketDateVos.add(ticketDateVo);
            });
        }
        return ticketDateVos;
    }
}

