/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.tbltag.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.dao.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.report.model.constant.TicketConstant;
import com.bxm.report.model.dao.tbltag.TblAdPostionTag;
import com.bxm.report.model.dto.tbltag.TblAdTagDto;
import com.bxm.report.model.vo.tbltag.TblAdTagVo;
import com.bxm.report.service.tbltag.TblAdTagService;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TblAdTagServiceImpl
implements TblAdTagService {
    @Autowired
    private TblAdPostionTagMapperExt tblAdTagMapperExt;
    List<TblAdTagVo> parentList = null;

    @Override
    public List<TblAdTagVo> findTblAdTagListByType(Integer parentId, Integer type) {
        List<TblAdTagVo> list = this.recursiveFindTblAdTag(parentId, type);
        return list;
    }

    @Override
    public List<TblAdTagVo> findTblAdTagById(Integer parentId) {
        List list = this.tblAdTagMapperExt.findTblAdTagList(parentId, Integer.valueOf(2), null);
        return list;
    }

    @Override
    public TblAdTagVo updateFindTblAdTag(Integer id, Integer type) {
        this.parentList = new ArrayList<TblAdTagVo>();
        TblAdTagVo tblAdTag = this.tblAdTagMapperExt.selectByPrimaryKey(id);
        if (tblAdTag.getParentId() == 0) {
            return tblAdTag;
        }
        List<TblAdTagVo> parentList = this.findParentList(tblAdTag.getId(), "1");
        parentList.stream().forEach(vo -> vo.setBrotherList(this.tblAdTagMapperExt.findTblAdTagList(vo.getParentId(), type, null)));
        tblAdTag.setParentList(parentList);
        tblAdTag.setBrotherList(this.tblAdTagMapperExt.findTblAdTagList(tblAdTag.getParentId(), type, null));
        return tblAdTag;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.DEFAULT, timeout=36000, rollbackFor={Exception.class})
    public boolean addTag(TblAdPostionTag tblAdTag) throws ValidateException {
        TblAdTagVo tblAdTagVo = this.findParentTag(tblAdTag.getParentId());
        Integer code = this.tblAdTagMapperExt.findMaxCode();
        tblAdTag.setCode(Integer.valueOf(code + 1));
        tblAdTag.setCreateTime(new Date());
        this.buildTagFullInfo(tblAdTag, (TblAdPostionTag)tblAdTagVo);
        return this.tblAdTagMapperExt.insert(tblAdTag) > 0;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.DEFAULT, timeout=36000, rollbackFor={Exception.class})
    public Boolean updateTag(TblAdTagDto tblAdTagDto, String user) throws ValidateException {
        TblAdTagVo entity = this.tblAdTagMapperExt.selectByPrimaryKey(tblAdTagDto.getId());
        if (null == entity) {
            throw new NullPointerException("\u672a\u67e5\u8be2\u5230\u6807\u7b7e\uff01");
        }
        TblAdTagVo tblAdTagVo = this.findParentTag(tblAdTagDto.getParentId());
        TblAdPostionTag tblAdTag = new TblAdPostionTag();
        BeanUtils.copyProperties((Object)tblAdTagDto, (Object)tblAdTag);
        tblAdTag.setModifyUser(user);
        tblAdTag.setModifyTime(new Date());
        this.buildTagFullInfo((TblAdPostionTag)entity, (TblAdPostionTag)tblAdTagVo);
        tblAdTag.setFullCodePath(entity.getFullCodePath());
        tblAdTag.setFullNameStr(entity.getFullNameStr());
        return this.tblAdTagMapperExt.updateByPrimaryKeySelective(tblAdTag) > 0;
    }

    private TblAdTagVo findParentTag(Integer parentId) {
        TblAdTagVo tblAdTagVo = null;
        if (!parentId.equals(TicketConstant.TicketTag.BASIC_PARENT_ID) && null == (tblAdTagVo = this.tblAdTagMapperExt.selectByPrimaryKey(parentId))) {
            throw new NullPointerException("\u672a\u67e5\u8be2\u5230\u7236\u6807\u7b7e\uff01");
        }
        return tblAdTagVo;
    }

    private void buildTagFullInfo(TblAdPostionTag entity, TblAdPostionTag parent) {
        if (null != parent) {
            entity.setFullCodePath(StringUtils.join((Object[])new Serializable[]{parent.getFullCodePath(), entity.getCode(), "."}));
            entity.setFullNameStr(StringUtils.join((Object[])new String[]{parent.getFullNameStr(), entity.getName(), "."}));
        } else {
            entity.setFullCodePath(entity.getCode().toString() + ".");
            entity.setFullNameStr(entity.getName() + ".");
        }
    }

    private List<TblAdTagVo> recursiveFindTblAdTag(Integer parentId, Integer type) {
        List list = null;
        if (type == 1) {
            return this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(0), Integer.valueOf(1), null);
        }
        list = this.tblAdTagMapperExt.findTblAdTagList(parentId, type, null);
        if (list == null) {
            return null;
        }
        list.stream().forEach(vo -> {
            List<TblAdTagVo> childList = this.recursiveFindTblAdTag(vo.getId(), type);
            vo.setChildList(childList);
        });
        return list;
    }

    private List<TblAdTagVo> findParentList(Integer id, String type) {
        TblAdTagVo tblAdTagVo = this.tblAdTagMapperExt.selectByPrimaryKey(id);
        if (!type.equals("1")) {
            this.parentList.add(tblAdTagVo);
        }
        if (tblAdTagVo.getParentId() == 0) {
            return this.parentList;
        }
        this.findParentList(tblAdTagVo.getParentId(), type);
        return this.parentList;
    }

    @Override
    public PageInfo<TblAdTagVo> findfindTblAdTagByNameAndID(String param, String type) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)param)) {
            paramMap.put("param", param);
        } else {
            paramMap.put("param", "");
        }
        List<TblAdTagVo> list = this.tblAdTagMapperExt.findTblAdTagChildByName(paramMap);
        TblAdTagVo tblAdTagVo = this.tblAdTagMapperExt.findTblAdTagByName(paramMap);
        if (tblAdTagVo == null) {
            return null;
        }
        list = this.getLabelList(type, list, tblAdTagVo);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<TblAdTagVo> findAll(Integer pageNum, Integer pageSize, String name) {
        if (StringUtils.isNotEmpty((CharSequence)(pageNum + "")) && StringUtils.isNotEmpty((CharSequence)(pageSize + ""))) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List list = this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(-1), Integer.valueOf(2), name);
        PageInfo page = new PageInfo(list);
        page.setList(this.getLabelList("1", list, null));
        return page;
    }

    @Override
    public JSONObject findTblAdTagByCodeStr(String str) {
        ArrayList categoryLableList = new ArrayList();
        ArrayList attrlableList = new ArrayList();
        JSONObject entity = new JSONObject();
        String[] codes = str.split(",");
        Arrays.stream(codes).forEach(code -> {
            this.parentList = new ArrayList<TblAdTagVo>();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("codestr", (String)code);
            TblAdTagVo tblAdTagVo = this.tblAdTagMapperExt.findTblAdTagByName(paramMap);
            if (tblAdTagVo != null) {
                if (tblAdTagVo.getTypeTag() == 1) {
                    attrlableList.add(tblAdTagVo);
                } else if (tblAdTagVo.getParentId() == 0) {
                    categoryLableList.add(tblAdTagVo);
                } else {
                    List<TblAdTagVo> parentList = this.findParentList(tblAdTagVo.getParentId(), "2");
                    tblAdTagVo.setParentList(parentList);
                    categoryLableList.add(tblAdTagVo);
                }
            }
        });
        entity.put("attributeLable", attrlableList);
        entity.put("categoryLagle", categoryLableList);
        return entity;
    }

    private List<TblAdTagVo> getLabelList(String type, List<TblAdTagVo> list, TblAdTagVo tblAdTagVo) {
        if (type.equals("1")) {
            if (tblAdTagVo != null) {
                list.add(tblAdTagVo);
            }
        } else {
            list.stream().sorted(Comparator.comparing(TblAdPostionTag::getCode)).forEach(vo -> {
                vo.setBrotherList(null);
                vo.setParentList(null);
                vo.setChildList(null);
            });
        }
        list.stream().forEach(vo -> {
            this.parentList = new ArrayList<TblAdTagVo>();
            vo.setBrotherList(null);
            vo.setParentList(null);
            vo.setChildList(null);
            if (vo.getParentId() == 0) {
                vo.setParentFirstName("--");
                vo.setParentScendName("--");
            } else {
                List<Object> listchile = this.findParentList(vo.getId(), "2");
                listchile = listchile.stream().filter(childvo -> !childvo.getName().equals(vo.getName())).collect(Collectors.toList());
                if ((listchile = listchile.stream().sorted(Comparator.comparing(TblAdPostionTag::getCode)).collect(Collectors.toList())).size() > 1) {
                    vo.setParentFirstName(((TblAdTagVo)listchile.get(0)).getName());
                    vo.setParentScendName(((TblAdTagVo)listchile.get(1)).getName());
                } else {
                    vo.setParentFirstName(((TblAdTagVo)listchile.get(0)).getName());
                    vo.setParentScendName("--");
                }
            }
        });
        list = list.stream().sorted(Comparator.comparing(TblAdPostionTag::getId)).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<TblAdTagVo> tblTagByFirstCode() {
        return this.tblAdTagMapperExt.tblTagByFirstCode();
    }

    @Override
    public PageInfo<TblAdTagVo> findNewTreeAll(Integer pageNum, Integer pageSize, Integer type, String name, Integer parentId) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<Object> list = new ArrayList();
        list = this.findNewTreeAllTblAdTag(parentId, type, name);
        PageInfo page = new PageInfo(list);
        return page;
    }

    private List<TblAdTagVo> findNewTreeAllTblAdTag(Integer parentId, Integer type, String name) {
        List list = null;
        if (type == 1) {
            return this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(0), type, name);
        }
        list = this.tblAdTagMapperExt.findTblAdTagList(parentId, type, name);
        if (list == null) {
            return null;
        }
        list.stream().forEach(vo -> {
            List<TblAdTagVo> childList = this.findNewTreeAllTblAdTag(vo.getId(), type, null);
            vo.setChildList(childList);
        });
        return list;
    }

    @Override
    public PageInfo<TblAdTagVo> findNewAll(Integer pageNum, Integer pageSize, String name, Integer type) {
        if (StringUtils.isNotEmpty((CharSequence)(pageNum + "")) && StringUtils.isNotEmpty((CharSequence)(pageSize + ""))) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List list = this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(-1), type, name);
        PageInfo page = new PageInfo(list);
        page.setList(this.getNewLabelList("1", list, null, type));
        return page;
    }

    @Override
    public List<TblAdPostionTag> findOneLevelTag(Integer tagType) {
        return this.tblAdTagMapperExt.findOneLevelTag(tagType);
    }

    private List<TblAdTagVo> getNewLabelList(String bs, List<TblAdTagVo> list, TblAdTagVo tblAdTagVo, Integer type) {
        if (bs.equals("1")) {
            if (tblAdTagVo != null) {
                list.add(tblAdTagVo);
            }
        } else {
            list.stream().sorted(Comparator.comparing(TblAdPostionTag::getCode)).forEach(vo -> {
                vo.setBrotherList(null);
                vo.setParentList(null);
                vo.setChildList(null);
            });
        }
        list.stream().forEach(vo -> {
            this.parentList = new ArrayList<TblAdTagVo>();
            vo.setBrotherList(null);
            vo.setParentList(null);
            vo.setChildList(null);
            if (vo.getParentId() == 0) {
                vo.setParentFirstName("--");
                vo.setParentScendName("--");
            } else {
                List<Object> listchile = this.findParentList(vo.getId(), type + "");
                listchile = listchile.stream().filter(childvo -> !childvo.getName().equals(vo.getName())).collect(Collectors.toList());
                if ((listchile = listchile.stream().sorted(Comparator.comparing(TblAdPostionTag::getCode)).collect(Collectors.toList())).size() > 1) {
                    vo.setParentFirstName(((TblAdTagVo)listchile.get(0)).getName());
                    vo.setParentScendName(((TblAdTagVo)listchile.get(1)).getName());
                } else {
                    vo.setParentFirstName(((TblAdTagVo)listchile.get(0)).getName());
                    vo.setParentScendName("--");
                }
            }
        });
        list = list.stream().sorted(Comparator.comparing(TblAdPostionTag::getId)).collect(Collectors.toList());
        return list;
    }
}

