/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateFormatUtil {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static Long getMillisecondByDate(String date) {
        LocalDateTime localDateTime = LocalDateTime.from(LocalDate.parse(date, dateTimeFormatter).atStartOfDay());
        long timestamp = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timestamp;
    }

    public static Long getMillisecondByPlusDate(String date, long days) {
        LocalDateTime localDateTime = LocalDateTime.from(LocalDate.parse(date, dateTimeFormatter).atStartOfDay());
        localDateTime = localDateTime.plusDays(days);
        long timestamp = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timestamp;
    }

    public static Long getMillisecondByMinusDate(String date, long days) {
        LocalDateTime localDateTime = LocalDateTime.from(LocalDate.parse(date, dateTimeFormatter).atStartOfDay());
        localDateTime = localDateTime.minusDays(days);
        long timestamp = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timestamp;
    }

    public static int getDateHour(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.getHour();
    }
}

