/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.utils;

import com.bxm.util.StringUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.commons.lang.StringUtils;

public class DoubleUtil {
    private static NumberFormat formatter = DecimalFormat.getPercentInstance();

    public static Double formatDouble(String num1, String num2) {
        if (StringUtils.isBlank((String)num1) || StringUtils.isBlank((String)num2)) {
            return null;
        }
        if (!StringUtil.isPositiveNumber((String)num1) || !StringUtil.isPositiveNumber((String)num2)) {
            return null;
        }
        BigDecimal b1 = new BigDecimal(Double.valueOf(num1));
        BigDecimal b2 = new BigDecimal(Double.valueOf(num2));
        double num = 0.0;
        if (b2.compareTo(new BigDecimal(BigInteger.ZERO)) != 0) {
            num = b1.divide(b2, 4, 1).multiply(new BigDecimal(100)).doubleValue();
        }
        return num;
    }

    public static Double doubleSum(Double num1, Double num2) {
        BigDecimal b1 = new BigDecimal(num1.toString());
        BigDecimal b2 = new BigDecimal(num2.toString());
        return new Double(b1.add(b2).doubleValue());
    }

    public static String percent(Double number) {
        if (number == null) {
            return null;
        }
        return formatter.format(number);
    }

    static {
        formatter.setMaximumFractionDigits(2);
    }
}

