/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.utils;

import com.bxm.dao.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisAppOSVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisMediaVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.BaseAnalysisVO;
import com.bxm.report.facade.app.AppEntranceFacadeIntegration;
import com.bxm.report.facade.app.ProviderAppFacadeIntegration;
import com.bxm.report.model.vo.analysis.AnalysisPaymentTypeVO;
import com.bxm.report.model.vo.analysis.AnalysisRegionVO;
import com.bxm.report.model.vo.analysis.AnalysisTagTypeVO;
import com.bxm.report.model.vo.analysis.AnalysisTrendVO;
import com.bxm.report.service.utils.CollectionDataCopyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TicketAnalysisHelper {
    @Autowired
    private ProviderAppFacadeIntegration appFacadeIntegration;
    @Autowired
    private AppEntranceFacadeIntegration appEntranceFacadeIntegration;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;

    private Map<String, String> getAppNameMap(List<String> appKeys) {
        if (CollectionUtils.isEmpty(appKeys)) {
            return Collections.emptyMap();
        }
        List infoAppMsgs = this.appFacadeIntegration.getListByAppKeys(appKeys);
        if (CollectionUtils.isEmpty((Collection)infoAppMsgs)) {
            return Collections.emptyMap();
        }
        return infoAppMsgs.stream().collect(HashMap::new, (k, v) -> k.put(v.getAppKey(), v.getAppName()), HashMap::putAll);
    }

    private Map<String, String> getPositionNameMap(List<String> positionIds) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return Collections.emptyMap();
        }
        List adPositions = this.appEntranceFacadeIntegration.getListByPositionIds(positionIds);
        if (CollectionUtils.isEmpty((Collection)adPositions)) {
            return Collections.emptyMap();
        }
        return adPositions.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v.getAppEntranceName()), HashMap::putAll);
    }

    private Map<Integer, String> getTagTypeName(List<Integer> tagCodes) {
        if (CollectionUtils.isEmpty(tagCodes)) {
            return Collections.emptyMap();
        }
        List tblAdTagVos = this.tblAdPostionTagMapperExt.findByCodes(tagCodes);
        if (CollectionUtils.isEmpty((Collection)tblAdTagVos)) {
            return Collections.emptyMap();
        }
        return tblAdTagVos.stream().collect(HashMap::new, (k, v) -> k.put(v.getCode(), v.getName()), HashMap::putAll);
    }

    public Page<com.bxm.report.model.vo.analysis.AnalysisMediaVO> convertAndBuildByMedia(Page<AnalysisMediaVO> page) {
        Page<com.bxm.report.model.vo.analysis.AnalysisMediaVO> resultPage = this.pageCopy(page, com.bxm.report.model.vo.analysis.AnalysisMediaVO.class);
        List list = resultPage.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resultPage;
        }
        com.bxm.report.model.vo.analysis.AnalysisMediaVO mediaVO = (com.bxm.report.model.vo.analysis.AnalysisMediaVO)list.get(1);
        if (null == mediaVO) {
            return resultPage;
        }
        if (StringUtils.isNotBlank((CharSequence)mediaVO.getAppKey())) {
            List<String> appKeys = list.stream().map(com.bxm.report.model.vo.analysis.AnalysisMediaVO::getAppKey).collect(Collectors.toList());
            Map<String, String> groupByAppKey = this.getAppNameMap(appKeys);
            ((com.bxm.report.model.vo.analysis.AnalysisMediaVO)list.get(0)).setAppName("\u5408\u8ba1");
            list.forEach(analysisMediaVO -> analysisMediaVO.setAppName((String)groupByAppKey.get(analysisMediaVO.getAppKey())));
        } else if (StringUtils.isNotBlank((CharSequence)mediaVO.getPositionId())) {
            List<String> positionIds = list.stream().map(com.bxm.report.model.vo.analysis.AnalysisMediaVO::getPositionId).collect(Collectors.toList());
            Map<String, String> groupByAppKey = this.getPositionNameMap(positionIds);
            ((com.bxm.report.model.vo.analysis.AnalysisMediaVO)list.get(0)).setPositionName("\u5408\u8ba1");
            list.forEach(analysisMediaVO -> analysisMediaVO.setPositionName((String)groupByAppKey.get(analysisMediaVO.getPositionId())));
        }
        return resultPage;
    }

    public Page<com.bxm.report.model.vo.analysis.AnalysisAppOSVO> convertAndBuildByAppOS(Page<AnalysisAppOSVO> page) {
        Page<com.bxm.report.model.vo.analysis.AnalysisAppOSVO> analysisAppOSVOPage = this.pageCopy(page, com.bxm.report.model.vo.analysis.AnalysisAppOSVO.class);
        if (CollectionUtils.isEmpty((Collection)analysisAppOSVOPage.getList())) {
            return analysisAppOSVOPage;
        }
        com.bxm.report.model.vo.analysis.AnalysisAppOSVO total = (com.bxm.report.model.vo.analysis.AnalysisAppOSVO)analysisAppOSVOPage.getList().get(0);
        if (null == total) {
            return analysisAppOSVOPage;
        }
        total.setAppOSName("\u5408\u8ba1");
        return analysisAppOSVOPage;
    }

    public Page<AnalysisPaymentTypeVO> convertAndBuildByPaymentType(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisPaymentTypeVO> page) {
        Page<AnalysisPaymentTypeVO> resultPage = this.pageCopy(page, AnalysisPaymentTypeVO.class);
        if (CollectionUtils.isEmpty((Collection)resultPage.getList())) {
            return resultPage;
        }
        AnalysisPaymentTypeVO total = (AnalysisPaymentTypeVO)resultPage.getList().get(0);
        if (null == total) {
            return resultPage;
        }
        total.setUaName("\u5408\u8ba1");
        return resultPage;
    }

    public Page<AnalysisRegionVO> convertAndBuildByRegion(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisRegionVO> page) {
        Page<AnalysisRegionVO> resultPage = this.pageCopy(page, AnalysisRegionVO.class);
        List list = resultPage.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resultPage;
        }
        AnalysisRegionVO analysisRegionVO = (AnalysisRegionVO)list.get(1);
        if (null != analysisRegionVO) {
            if (StringUtils.isNotBlank((CharSequence)analysisRegionVO.getCity())) {
                ((AnalysisRegionVO)resultPage.getList().get(0)).setCity("\u5408\u8ba1");
            } else {
                ((AnalysisRegionVO)resultPage.getList().get(0)).setProvince("\u5408\u8ba1");
            }
        }
        return resultPage;
    }

    public Page<AnalysisTagTypeVO> convertAndBuildByTagType(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisTagTypeVO> page) {
        Page<AnalysisTagTypeVO> resultPage = this.pageCopy(page, AnalysisTagTypeVO.class);
        List list = resultPage.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resultPage;
        }
        AnalysisTagTypeVO total = (AnalysisTagTypeVO)list.get(0);
        if (null == total) {
            return resultPage;
        }
        total.setAdTypeName("\u5408\u8ba1");
        List<Integer> tagCodes = list.stream().map(AnalysisTagTypeVO::getAdTypeCode).collect(Collectors.toList());
        Map<Integer, String> groupByCode = this.getTagTypeName(tagCodes);
        list.forEach(analysisTagTypeVO -> analysisTagTypeVO.setAdTypeName((String)groupByCode.get(analysisTagTypeVO.getAdTypeCode())));
        return resultPage;
    }

    public Page<AnalysisTrendVO> convertAndBuildByTrend(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisTrendVO> page) {
        Page<AnalysisTrendVO> resultPage = this.pageCopy(page, AnalysisTrendVO.class);
        List list = resultPage.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resultPage;
        }
        AnalysisTrendVO analysisTrendVO = (AnalysisTrendVO)list.get(1);
        if (null != analysisTrendVO) {
            if (StringUtils.isNotBlank((CharSequence)analysisTrendVO.getHour())) {
                ((AnalysisTrendVO)resultPage.getList().get(0)).setHour("\u5408\u8ba1");
            } else {
                ((AnalysisTrendVO)resultPage.getList().get(0)).setCreateTime("\u5408\u8ba1");
            }
        }
        return resultPage;
    }

    private <T> Page<T> pageCopy(Page<? extends BaseAnalysisVO> page, Class<T> clazz) {
        Page resultPage = new Page();
        BeanUtils.copyProperties(page, (Object)resultPage);
        List<T> list = CollectionDataCopyUtil.copyList(page.getList(), clazz);
        resultPage.setList(list);
        return resultPage;
    }

    public Map<String, Map<String, Double>> commonAnalysisChat(Map<String, Map<String, Double>> map, String analysisType, String groupByField) {
        switch (analysisType) {
            case "MEDIA": {
                HashSet<String> ids = new HashSet<String>();
                for (Map<String, Double> childMap : map.values()) {
                    ids.addAll(childMap.keySet());
                }
                if (StringUtils.isBlank((CharSequence)groupByField) || "MEDIA".equals(groupByField)) {
                    Map<String, String> appNameMap = this.getAppNameMap(new ArrayList<String>(ids));
                    if (MapUtils.isEmpty(appNameMap)) {
                        return map;
                    }
                    return this.translateMapKey(map, appNameMap);
                }
                Map<String, String> positionNameMap = this.getPositionNameMap(new ArrayList<String>(ids));
                if (MapUtils.isEmpty(positionNameMap)) {
                    return map;
                }
                return this.translateMapKey(map, positionNameMap);
            }
            case "TAG_TYPE": {
                HashSet<String> tagCodes = new HashSet<String>();
                for (Map<String, Double> map2 : map.values()) {
                    tagCodes.addAll(map2.keySet());
                }
                ArrayList<Integer> tagCodeList = new ArrayList<Integer>(tagCodes.size());
                for (String tagCode : tagCodes) {
                    if (!StringUtils.isNumeric((CharSequence)tagCode)) continue;
                    tagCodeList.add(Integer.valueOf(tagCode));
                }
                Map<Integer, String> map3 = this.getTagTypeName(tagCodeList);
                HashMap<String, String> newTagNameMap = new HashMap<String, String>(map3.size());
                for (Map.Entry<Integer, String> entry : map3.entrySet()) {
                    newTagNameMap.put(entry.getKey().toString(), entry.getValue());
                }
                return this.translateMapKey(map, newTagNameMap);
            }
        }
        return map;
    }

    private Map<String, Map<String, Double>> translateMapKey(Map<String, Map<String, Double>> target, Map<String, String> source) {
        HashMap<String, Map<String, Double>> resultMap = new HashMap<String, Map<String, Double>>(target.size());
        for (Map.Entry<String, Map<String, Double>> parentEntry : target.entrySet()) {
            HashMap<String, Double> newChildMap = new HashMap<String, Double>(parentEntry.getValue().size());
            Double other = parentEntry.getValue().get("\u5176\u4ed6");
            if (null != other) {
                newChildMap.put("\u5176\u4ed6", other);
                parentEntry.getValue().remove("\u5176\u4ed6");
            }
            for (Map.Entry<String, Double> doubleEntry : parentEntry.getValue().entrySet()) {
                String name = source.get(doubleEntry.getKey());
                name = StringUtils.isBlank((CharSequence)name) ? "--" + doubleEntry.getKey() + "--" : name;
                newChildMap.put(name, doubleEntry.getValue());
            }
            resultMap.put(parentEntry.getKey(), newChildMap);
        }
        return resultMap;
    }
}

