package com.bxm.adsalgorithm.facade.service;


import com.bxm.adsalgorithm.facade.concants.AdsFMFacadeConstants;
import com.bxm.adsalgorithm.facade.model.DNNFeatureDto;
import com.bxm.adsalgorithm.facade.model.DNNTicketCTRRO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * Description FM算法相关接口
 *
 * @author lala
 * <p>
 * Date 2019/9/3 17:20
 */
@FeignClient(name = AdsFMFacadeConstants.SERVER_NAME)
public interface DNNFacadeService {


    /**
     * 根据参数获取CTR列表
     *
     * @return
     */
    @RequestMapping(value = "/dnn/getFMCTRByList", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    List<DNNTicketCTRRO> getFMCTRByList(@RequestBody List<DNNFeatureDto> featureDtoList);


    /**
     * 根据参数获取ctr列表
     *
     * @return
     */
    @RequestMapping(value = "/dnn/getCTRByParams", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public List<DNNTicketCTRRO> getCTRByParams(@RequestBody List<DNNFeatureDto> featureDtoList,
                                               @RequestParam("modelId")String modelId);


}
