package com.bxm.adscounter.api.ticket;

import com.bxm.adscounter.facade.SspUserFacadeService;
import com.bxm.adscounter.facade.model.SspUserData;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 开放api<br/>
 *
 * @author kerry.jiang
 * @date 2021/9/9 18:09
 */
@RequestMapping("/openapi")
@RestController
public class OpenApiController {

    private final SspUserFacadeService sspUserFacadeService;

    public OpenApiController(SspUserFacadeService sspUserFacadeService) {
        this.sspUserFacadeService = sspUserFacadeService;
    }

    @PostMapping("/udata")
    public ResponseEntity<List<SspUserData>> getUserData(@RequestParam("appId") String appId,
                                                         @RequestParam(name = "positionId", required = false) String positionId,
                                                         @RequestParam("cuids") String[] cuids,
                                                         @RequestParam("date") String date) {
        return ResponseEntity.ok(sspUserFacadeService.getUserData(appId, positionId, cuids, date));
    }
}
