package com.bxm.adscounter.api.ticket.conversion;

import com.bxm.adscounter.api.autoconfigure.ApplicationGlobalConfig;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Map;
import java.util.Objects;

/**
 * @author allen
 * @date 2022-04-12
 * @since 1.0
 */
@Slf4j
@Configuration
public class ConversionServiceImpl implements ConversionService {

    private final ApplicationGlobalConfig properties;
    private final OpenLogClient openLogClient;

    public ConversionServiceImpl(ApplicationGlobalConfig properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    public boolean sendOpenLog(Conversion conv) {
        String bxmId = conv.getBxmId();

        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.INADS);
        map.setMt(Inads.Mt.AdConversion.original());
        map.setIp(conv.getIp());
        map.setUa(conv.getUa());
        map.setRef(conv.getRefer());
        map.putIfNotBlank(Inads.Param.BXMID, bxmId);
        map.putIfNotBlank(Inads.Param.CONVERSION_TYPE, conv.getType());
        map.putIfNotBlank(Inads.Param.CONVERSION_STATUS, conv.getStatus());

        Map<String, Object> ext = Maps.newHashMap();
        ext.put("beType", conv.getType());
        ext.put("transformType", conv.getTransformType());

        map.put(Inads.Param.EXT, JsonHelper.convert(ext));

        String uri = map.createOpenLogRequestUri(properties.getOpenLogRequestDomain());
        openLogClient.asyncRequest(uri, fallback ->
                log.warn("request: {}, exception: {}", fallback.getUrl(), Objects.nonNull(fallback.getException()) ? fallback.getException().getMessage() : "-"));

        return true;
    }

}
