/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.pair;

import com.bxm.warcar.integration.pair.Value;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class DefaultValue
implements Value {
    private static final char DEFAULT_SPLIT_CHAR = ',';
    private final String value;

    public DefaultValue(String value) {
        this.value = value;
    }

    @Override
    public String of() {
        return this.value;
    }

    @Override
    public List<String> ofArrayList() {
        if (StringUtils.isBlank((String)this.value)) {
            return null;
        }
        return Lists.newArrayList((Object[])this.simpleSplitToArray());
    }

    @Override
    public Integer ofInt() {
        return TypeHelper.castToInt((Object)this.value);
    }

    @Override
    public int ofInt(int defaultValue) {
        return NumberUtils.toInt((String)this.value, (int)defaultValue);
    }

    @Override
    public Boolean ofBoolean() {
        return TypeHelper.castToBoolean((Object)this.value);
    }

    @Override
    public boolean ofBoolean(boolean defaultValue) {
        Boolean b = this.ofBoolean();
        return null == b ? defaultValue : b;
    }

    @Override
    public Set<String> ofHashSet() {
        if (StringUtils.isBlank((String)this.value)) {
            return null;
        }
        return Sets.newHashSet((Object[])this.simpleSplitToArray());
    }

    @Override
    public <T> T toObject(Class<T> cls) {
        if (StringUtils.isBlank((String)this.value)) {
            return null;
        }
        return JsonHelper.convert(this.value, cls);
    }

    private String[] simpleSplitToArray() {
        return StringUtils.split((String)this.value, (char)',');
    }
}

