/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.alions;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.bxm.warcar.mq.DelayTimeLevel;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendException;
import com.bxm.warcar.mq.SendResult;
import com.bxm.warcar.mq.Type;
import com.bxm.warcar.utils.LifeCycle;
import java.util.Map;
import java.util.Properties;

public class AlionsProducer
extends LifeCycle
implements Producer {
    private final Properties properties = new Properties();
    private com.aliyun.openservices.ons.api.Producer producer;

    public AlionsProducer(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public SendResult send(Message message) {
        com.aliyun.openservices.ons.api.Message msg = new com.aliyun.openservices.ons.api.Message();
        msg.setTopic(message.getTopic());
        msg.setBody(message.getBody());
        msg.setTag(message.getTags());
        int level = message.getDelayTimeLevel();
        if (level > 0) {
            msg.setStartDeliverTime(DelayTimeLevel.ofSystemTimeInMillis(level));
        }
        try {
            com.aliyun.openservices.ons.api.SendResult sendResult = this.producer.send(msg);
            if (null == sendResult) {
                throw new SendException();
            }
            return new SendResult(sendResult.getMessageId());
        }
        catch (Exception e) {
            throw new SendException(e);
        }
    }

    @Override
    protected void doInit() {
        this.producer = ONSFactory.createProducer((Properties)this.properties);
        if (null != this.producer && this.producer.isClosed()) {
            this.producer.start();
        }
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public void start() {
        this.init();
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public boolean isStarted() {
        if (null == this.producer) {
            return false;
        }
        return this.producer.isStarted();
    }

    @Override
    public Type getType() {
        return Type.AliOns;
    }
}

