/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.mongo;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.mongo.MongoReactiveHealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.mongo.MongoHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
@ConditionalOnClass(value={MongoTemplate.class})
@ConditionalOnBean(value={MongoTemplate.class})
@ConditionalOnEnabledHealthIndicator(value="mongo")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, MongoReactiveHealthIndicatorAutoConfiguration.class})
public class MongoHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<MongoHealthIndicator, MongoTemplate> {
    private final Map<String, MongoTemplate> mongoTemplates;

    MongoHealthIndicatorAutoConfiguration(Map<String, MongoTemplate> mongoTemplates) {
        this.mongoTemplates = mongoTemplates;
    }

    @Bean
    @ConditionalOnMissingBean(name={"mongoHealthIndicator"})
    public HealthIndicator mongoHealthIndicator() {
        return this.createHealthIndicator(this.mongoTemplates);
    }
}

