/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.configure.spring;

import com.bxm.warcar.configure.EnvironmentLoader;
import com.bxm.warcar.configure.loader.EnvironmentLoaderFactory;
import com.bxm.warcar.configure.update.UpdateEvent;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public final class SpringBootEnvironmentListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
DisposableBean,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootEnvironmentListener.class);
    private static final String ADDRESS = "configure.address";
    private static final String KEY = "configure.key";
    private EnvironmentLoader environmentLoader;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        boolean contains = environment.containsProperty(ADDRESS);
        if (!contains) {
            return;
        }
        String address = environment.getProperty(ADDRESS);
        String key = environment.getProperty(KEY);
        if (null == address || null == key) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Environment property '{}','{}' must not be null.", (Object)ADDRESS, (Object)KEY);
            }
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loading properties '{}' from {}", (Object)key, (Object)address);
        }
        this.environmentLoader = EnvironmentLoaderFactory.create(address.toString(), key.toString(), properties -> {
            this.refresh(environment, properties);
            if (null != this.applicationContext) {
                this.applicationContext.publishEvent((ApplicationEvent)new UpdateEvent(this));
            }
        });
        if (null == this.environmentLoader) {
            return;
        }
        List<Properties> properties2 = this.environmentLoader.loadProperties();
        this.refresh(environment, properties2);
    }

    public void destroy() throws Exception {
        this.closeLoader(this.environmentLoader);
    }

    private void closeLoader(EnvironmentLoader environmentLoader) {
        try {
            environmentLoader.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void refresh(ConfigurableEnvironment environment, List<Properties> properties) {
        if (null != properties) {
            MutablePropertySources propertySources = environment.getPropertySources();
            for (int i = 0; i < properties.size(); ++i) {
                String name = "userRemoteDefinedProperties-" + i;
                propertySources.addFirst((PropertySource)new PropertiesPropertySource(name, properties.get(i)));
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Load successful on PropertySource '{}'", (Object)name);
            }
        }
    }
}

