/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.sdk.listener.eventbus;

import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.Topic;
import com.bxm.openlog.sdk.listener.eventbus.EventBusSubscriberMessageListener;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventBusBean;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventConfig;
import com.bxm.openlog.sdk.serial.Serialization;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.rocketmq.RocketmqProperties;
import com.bxm.warcar.mq.rocketmq.RocketmqConsumer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ClassUtils;

public class OpenLogEventBusFactory
implements BeanPostProcessor,
DisposableBean,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(OpenLogEventBusFactory.class);
    private final Map<String, OpenLogEventConfig> configFactoryMap = Maps.newHashMap();
    private final Map<String, Consumer> consumerMap = Maps.newHashMap();
    private final RocketmqProperties rocketmqProperties;
    private final Serialization serialization;

    public OpenLogEventBusFactory(RocketmqProperties rocketmqProperties, Serialization serialization) {
        this.rocketmqProperties = rocketmqProperties;
        this.serialization = serialization;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof OpenLogEventBusBean)) {
            return bean;
        }
        OpenLogEventBusBean busBean = (OpenLogEventBusBean)bean;
        String id = busBean.getId();
        Production production = busBean.getProduction();
        EventPark eventPark = busBean.getEventPark();
        Preconditions.checkNotNull((Object)((Object)production), (Object)"production");
        Preconditions.checkNotNull((Object)eventPark, (Object)"eventPark");
        ArrayList registry = Lists.newArrayList();
        busBean.bindTo(registry);
        if (CollectionUtils.isEmpty((Collection)registry)) {
            return bean;
        }
        for (OpenLogEventConfig config : registry) {
            String mt = config.getMt();
            String key = OpenLogEventBusFactory.getKey(production, mt);
            this.configFactoryMap.put(key, config);
            log.info("Registered OpenLogEvent {} - {}", (Object)key, (Object)ClassUtils.getShortName(config.getEventType()));
        }
        String topic = Topic.dispatchMtLog(production.getName());
        String consumerId = ("CID_EVENT_" + id + "_" + topic).toUpperCase();
        EventBusSubscriberMessageListener listener = new EventBusSubscriberMessageListener(topic, consumerId, this.serialization, eventPark, this.configFactoryMap);
        Consumer consumer = this.createConsumer(listener);
        this.consumerMap.put(consumerId, consumer);
        if (log.isInfoEnabled()) {
            log.info("Registered consumer {} for topic {}", (Object)consumerId, (Object)topic);
        }
        return bean;
    }

    public void destroy() throws Exception {
        for (Consumer consumer : this.consumerMap.values()) {
            consumer.shutdown();
        }
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        for (Consumer consumer : this.consumerMap.values()) {
            consumer.start();
            if (!log.isInfoEnabled()) continue;
            Listener listener = consumer.getMessageListener();
            log.info("Consumer topic:{} id:{} instance:{} has been started!", new Object[]{listener.getTopic(), listener.getConsumerId(), consumer});
        }
    }

    static String getKey(Production production, String mt) {
        return (Object)((Object)production) + "-" + mt;
    }

    private Consumer createConsumer(SingleMessageListener listener) {
        String nameSrvAddr = this.rocketmqProperties.getNameSrvAddr();
        return new RocketmqConsumer(nameSrvAddr, listener, listener.getConsumerId(), this.rocketmqProperties.getBrokerAddrAliasMap());
    }
}

