/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.api.ticket.conversion;

import com.bxm.adscounter.api.autoconfigure.ApplicationGlobalConfig;
import com.bxm.adscounter.api.ticket.conversion.Conversion;
import com.bxm.adscounter.api.ticket.conversion.ConversionService;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConversionServiceImpl
implements ConversionService {
    private static final Logger log = LoggerFactory.getLogger(ConversionServiceImpl.class);
    private final ApplicationGlobalConfig properties;
    private final OpenLogClient openLogClient;

    public ConversionServiceImpl(ApplicationGlobalConfig properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    public boolean sendOpenLog(Conversion conv) {
        String bxmId = conv.getBxmId();
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.INADS);
        map.setMt(Inads.Mt.AdConversion.original());
        map.setIp(conv.getIp());
        map.setUa(conv.getUa());
        map.setRef(conv.getRefer());
        map.putIfNotBlank("bxmid", bxmId);
        map.putIfNotBlank("conversion_type", conv.getType());
        map.putIfNotBlank("conversion_status", conv.getStatus());
        HashMap ext = Maps.newHashMap();
        ext.put("beType", conv.getType());
        ext.put("transformType", conv.getTransformType());
        map.put("ext", JsonHelper.convert((Object)ext));
        String uri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain());
        this.openLogClient.asyncRequest(uri, fallback -> log.warn("request: {}, exception: {}", (Object)fallback.getUrl(), (Object)(Objects.nonNull(fallback.getException()) ? fallback.getException().getMessage() : "-")));
        return true;
    }
}

