#!/bin/bash

if [ ! -f ~/run/adscounter-api.pid ]; then
  echo "Server [adscounter-api] doest not started!"
  exit
fi

pid=`cat ~/run/adscounter-api.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in adscounter-api.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [adscounter-api] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 60 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [adscounter-api] cannot stop, Please check pid file 'adscounter-api.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [adscounter-api] has been stoped!"
fi

rm -f ~/run/adscounter-api.pid