package com.bxm.adscounter.api.intercepor;

import com.bxm.warcar.validate.Validator;
import com.bxm.warcar.validate.factory.AnnotationValidatorFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 * <h3>验证器切面，前置通知拦截<code>*ServiceImpl(..)</code></h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
@Aspect
@Order(-1)
@Component
public class ValidateAspect {

    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateAspect.class);
    private final AnnotationValidatorFactory annotationValidatorFactory = new AnnotationValidatorFactory();

    @Before("execution(* com.bxm.adscounter.api.*.*Controller*.*(..))")
    public void before(JoinPoint point)  {
        Object[] args = point.getArgs();

        for (Object arg : args) {
            if (null == arg) {
                continue;
            }
            // TODO 需要验证父类和成员类中的注解是否会验证
            Validator validator = annotationValidatorFactory.create(arg.getClass());
            if (null != validator) {
                validator.validate(arg);
            }
        }
    }
}
