package com.bxm.adscounter.api.ticket.kuaishou;

import com.bxm.adscounter.facade.model.kuaishou.KuaishouTrackerDto;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.UrlHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author allen
 * @date 2021-09-15
 * @since 1.0
 */
@Slf4j
@RestController
@RequestMapping("/kuaishou")
public class KuaishouTrackerController {

    private final Updater updater;

    public KuaishouTrackerController(Updater updater) {
        this.updater = updater;
    }

    @GetMapping("/click_tracker")
    public ResponseEntity<Object> clickTracker(KuaishouTrackerDto kuaishouTrackerDto) {
        clickTracker0(kuaishouTrackerDto);
        return ResponseEntity.ok().build();
    }

    private void clickTracker0(KuaishouTrackerDto kuaishouTrackerDto) {
        String callback = kuaishouTrackerDto.getCallback();
        if (StringUtils.isBlank(callback)) {
            log.info("Empty value for callback!");
            return;
        }
        String url = UrlHelper.urlDecode(callback);
        String cbvalue = UrlHelper.getFirstValueOfParamName(url, "callback");
        if (StringUtils.isBlank(cbvalue)) {
            log.info("Cannot found value of callback at url {}", url);
            return;
        }
        updater.update(key(cbvalue), kuaishouTrackerDto, 10 * 60);

        if (log.isDebugEnabled()) {
            log.debug("Updated: {}", cbvalue);
        }
    }

    private KeyGenerator key(String cbvalue) {
        return () -> KeyBuilder.build("tracker", "kuaishou", cbvalue);
    }
}
