/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.api.ticket;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.api.ticket.conversion.Conversion;
import com.bxm.adscounter.api.ticket.conversion.ConversionService;
import com.bxm.adscounter.facade.model.AdGroupCountMsg;
import com.bxm.warcar.utils.HttpUtils;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdGroupController {
    private static final Logger log = LoggerFactory.getLogger(AdGroupController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AdGroupController.class);
    private final ConversionService conversionService;

    public AdGroupController(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @RequestMapping(value={"/shop/countInfo"}, method={RequestMethod.POST})
    public ResponseModel<String> adGroupCountInfo(AdGroupCountMsg adGroupCountMsg, HttpServletRequest request) {
        ResponseModel result;
        try {
            adGroupCountMsg = AdGroupController.fill(adGroupCountMsg, request);
            log.info("Trace: {}", (Object)JsonHelper.convert((Object)adGroupCountMsg));
            if (StringUtils.isNotBlank((CharSequence)adGroupCountMsg.getModeltype()) && "7".equals(adGroupCountMsg.getModeltype())) {
                this.sendOpenLog(adGroupCountMsg, request);
            }
            result = ResponseModelFactory.SUCCESS((Object)"success");
        }
        catch (Exception e) {
            result = ResponseModelFactory.FAILED500();
            LOGGER.error("shop/countInfo error request =" + adGroupCountMsg.toString(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/shop/effectEvent"})
    public ResponseModel<String> adGroupAdsCountInfo(AdGroupCountMsg adGroupCountMsg, HttpServletRequest request) {
        ResponseModel result;
        try {
            adGroupCountMsg = AdGroupController.fill(adGroupCountMsg, request);
            this.sendOpenLog(adGroupCountMsg, request);
            result = ResponseModelFactory.SUCCESS((Object)"success");
        }
        catch (Exception e) {
            result = ResponseModelFactory.FAILED500();
            LOGGER.error("shop/effectEvent error request =" + adGroupCountMsg.toString(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/shop/customizeEffectEvent"})
    public ResponseEntity<Object> customizeResponse(AdGroupCountMsg adGroupCountMsg, HttpServletRequest request) {
        HashMap res = Maps.newHashMap();
        try {
            adGroupCountMsg = AdGroupController.fill(adGroupCountMsg, request);
            this.sendOpenLog(adGroupCountMsg, request);
            res.put("code", 0);
        }
        catch (Exception e) {
            LOGGER.error("shop/effectEvent error request =" + adGroupCountMsg.toString(), (Throwable)e);
            res.put("code", 1);
        }
        return ResponseEntity.ok((Object)res);
    }

    private void sendOpenLog(AdGroupCountMsg adGroupCountMsg, HttpServletRequest request) {
        Conversion conversion = this.createConversion(adGroupCountMsg, request);
        this.conversionService.sendOpenLog(conversion);
    }

    private Conversion createConversion(AdGroupCountMsg adGroupCountMsg, HttpServletRequest request) {
        return Conversion.builder().bxmId(adGroupCountMsg.getBxm_id()).ip(adGroupCountMsg.getIpAddress()).ua(request.getHeader("User-Agent")).refer(adGroupCountMsg.getReferrer()).status(adGroupCountMsg.getStatus()).type(Objects.toString(adGroupCountMsg.getType(), "0")).transformType(this.getTransformType(adGroupCountMsg)).build();
    }

    private String getTransformType(AdGroupCountMsg adGroupMsg) {
        String transformType = adGroupMsg.getTransformType();
        if (StringUtils.isBlank((CharSequence)transformType)) {
            transformType = adGroupMsg.getEvent_type();
        }
        return transformType;
    }

    private static AdGroupCountMsg fill(AdGroupCountMsg adGroupCountMsg, HttpServletRequest request) {
        if (null == adGroupCountMsg) {
            adGroupCountMsg = new AdGroupCountMsg();
        }
        adGroupCountMsg.setIpAddress(HttpUtils.getIpFromHeader((HttpServletRequest)request));
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            int len;
            char[] buff = new char[1024];
            while ((len = reader.read(buff)) != -1) {
                sb.append(buff, 0, len);
            }
        }
        catch (IOException e) {
            LOGGER.error("[HttpParamUtils] checkAdGroupCountMsg error ======", (Throwable)e);
        }
        String params = sb.toString();
        if (StringUtils.isNotBlank((CharSequence)params)) {
            JSONObject json = JSONObject.parseObject((String)params);
            if (null == adGroupCountMsg.getParam()) {
                adGroupCountMsg.setParam(json.getString("param"));
            }
            if (null == adGroupCountMsg.getPhone()) {
                adGroupCountMsg.setPhone(json.getString("phone"));
            }
            if (null == adGroupCountMsg.getIdcardnum()) {
                adGroupCountMsg.setIdcardnum(json.getString("idcardnum"));
            }
            if (null == adGroupCountMsg.getShop_code()) {
                adGroupCountMsg.setShop_code(json.getString("shop_code"));
            }
            if (null == adGroupCountMsg.getBxm_id()) {
                String countId = json.getString("bxm_id");
                adGroupCountMsg.setBxm_id(StringUtils.isBlank((CharSequence)countId) || "null".equals(countId) ? "0" : countId);
            }
            if (null == adGroupCountMsg.getStatus()) {
                String status = json.getString("status");
                adGroupCountMsg.setStatus(StringUtils.isBlank((CharSequence)status) || "null".equals(status) ? "2" : status);
            }
            if (null == adGroupCountMsg.getModeltype()) {
                String modelType = json.getString("modeltype");
                adGroupCountMsg.setModeltype(StringUtils.isBlank((CharSequence)modelType) || "null".equals(modelType) ? "7" : modelType);
            }
            if (null == adGroupCountMsg.getSh()) {
                adGroupCountMsg.setSh(json.getInteger("sh"));
            }
            if (null == adGroupCountMsg.getSw()) {
                adGroupCountMsg.setSw(json.getInteger("sw"));
            }
            if (null == adGroupCountMsg.getTs()) {
                adGroupCountMsg.setTs(json.getLong("ts"));
            }
            if (null == adGroupCountMsg.getLocaurl()) {
                adGroupCountMsg.setLocaurl(json.getString("locaurl"));
            }
        }
        if (!StringUtils.isNumeric((CharSequence)adGroupCountMsg.getModeltype())) {
            adGroupCountMsg.setModeltype("7");
        }
        if (!StringUtils.isNumeric((CharSequence)adGroupCountMsg.getStatus())) {
            adGroupCountMsg.setStatus("2");
        }
        adGroupCountMsg.setReferrer(request.getHeader("Referer"));
        return adGroupCountMsg;
    }
}

