CREATE TABLE `tbl_rtb_conversion_log`
(
    `id`              bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `rtb`             varchar(6)          DEFAULT NULL COMMENT 'RTB',
    `bxmid`           varchar(64)         DEFAULT NULL COMMENT 'bxm_id',
    `type`            varchar(2)          DEFAULT NULL COMMENT '变现猫行为类型',
    `uid`             varchar(64)         DEFAULT NULL COMMENT 'UID',
    `time`            datetime            DEFAULT NULL COMMENT '触发时间',
    `adid`            varchar(10)         DEFAULT NULL COMMENT '礼券ID',
    `tagid`           varchar(64)         DEFAULT NULL COMMENT '广告位ID',
    `createid`        varchar(10)         DEFAULT NULL COMMENT '素材ID',
    `ip`              varchar(17)         DEFAULT NULL COMMENT 'IP',
    `ua`              varchar(2048)       DEFAULT NULL COMMENT 'UserAgent',
    `refer`           varchar(2048)       DEFAULT NULL COMMENT 'Referrer',
    `imei`            varchar(32)         DEFAULT NULL,
    `imei_md5`        varchar(32)         DEFAULT NULL,
    `androidid`       varchar(64)         DEFAULT NULL,
    `androidid_md5`   varchar(32)         DEFAULT NULL,
    `oaid`            varchar(64)         DEFAULT NULL,
    `oaid_md5`        varchar(32)         DEFAULT NULL,
    `idfa`            varchar(64)         DEFAULT NULL,
    `idfa_md5`        varchar(32)         DEFAULT NULL,
    `rtb_id`          varchar(128)        DEFAULT NULL COMMENT 'RTB ID',
    `rtb_request_uri` varchar(2048)       DEFAULT NULL,
    `rtb_event_type`  varchar(12)         DEFAULT NULL,
    `rtb_req_body`    text                DEFAULT NULL,
    `rtb_res_body`    text                DEFAULT NULL,
    `rtb_res_msg`     varchar(256)        DEFAULT NULL,
    `create_time`     datetime   NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_rtb` (`rtb`) USING BTREE,
    KEY `idx_bxmid` (`bxmid`) USING BTREE,
    KEY `idx_rtb_id` (`rtb_id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;