package com.bxm.adscounter.facade;

import com.bxm.adscounter.facade.model.kuaishou.KuaishouTrackerDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author allen
 * @date 2021-09-15
 * @since 1.0
 */
@FeignClient(AdscounterConstants.SERVICE_NAME)
public interface KuaishouTrackerService {

    @PostMapping("/kuaishouTrackerService/clickTracker")
    void clickTracker(@RequestBody KuaishouTrackerDto kuaishouTrackerDto);

    @GetMapping("/kuaishouTrackerService/getTrackerDto")
    KuaishouTrackerDto getTrackerDto(@RequestParam("callback") String callback);
}
