package com.bxm.adscounter.facade;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.adscounter.facade.model.SspUserData;


/**
 * ssp用户信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/9/9 18:13
 */
@FeignClient(AdscounterConstants.SERVICE_NAME)
public interface SspUserFacadeService {

    /**
     * 获取用户数据
     * @param appId 应用ID
     * @param positionId 广告位id
     * @param cuids 用户自定义ID
     * @param date 日期
     * @return 统计数据
     */
    @PostMapping("/userFacadeService/getUserData")
    List<SspUserData> getUserData(@RequestParam("appId") String appId,
                                  @RequestParam(name = "positionId", required = false) String positionId,
                                  @RequestParam("cuids") String[] cuids,
                                  @RequestParam("date") String date);
}
