package com.bxm.adscounter.facade.model;

import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <p> 广告组统计数据参数 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/8/9
 */
@Data
public class AdGroupCountMsg implements Serializable{
    private static final long serialVersionUID = -757734782728494378L;
    /**
     * ip地址
     */
    private String ipAddress;
    /**
     * 其它页面信息
     */
    private String param;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 身份证号码
     */
    private String idcardnum;
    /**
     * 广告组标志
     */
    private String shop_code;
    /**
     * 记录ID
     */
    private String bxm_id;
    /**
     * 状态
     */
    private String status;
    /**
     * 类型
     */
    private String modeltype;

    /**
     * 券码通知类型：1使用，2激活
     */
    private String action_type;
    /**
     * 客户端地址栏信息
     * @param locaurl value
     */
    private String locaurl;

    /**
     * 时间戳
     */
    private Long ts;
    /**
     * 屏幕分辨率的高
     */
    private  Integer sh;
    /**
     * 屏幕分辨率的宽
     */
    private Integer sw;

    private String referrer;

    /**
     * 有效数据行为类型
     */
    private Integer type;

    /**
     * 淘特的行为类型
     */
    private String transformType;
    /**
     * Yoqu 的行为类型
     */
    private String event_type;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
