package com.bxm.adscounter.facade;

/**
 * 数据中心埋点值
 * @author kerry.jiang
 * @date 2019/6/14
 * @since 1.0.0
 */
public enum DSMt {

    /** 不明的 */
    _OTHER(-99),

    //Coupons
    /** 广告请求 */
    _11001(11001),
    /** 入口曝光 */
    _11101(11101),
    /** 入口点击 */
    _11102(11102),
    /** 内容加载 */
    _11103(11103),
    /** 直接关闭 */
    _11104(11104),
    /** 点击领取 */
    _11105(11105),
    /** 下载APP */
    _11201(11201),
    /** 安装APP */
    _11202(11202),
    /** 关闭广告 */
    _11106(11106),
    /** 重复点开广告 */
    _11107(11107),
    /** 激活转化 */
    _11402(11402),
    //Coupons END

    //ADX
    /** 广告位竞价请求 */
    _12001(12001),
    /** 广告位出价请求 */
    _12002(12002),
    /** 广告位素材曝光 */
    _12003(12003),
    /** 广告位素材点击 */
    _12004(12004),
    //ADX END

    //Inspire
    /** 设备信息公参 */
//    _13001(13001),
    /** 广告曝光 */
    _13002(13002),
    /** 广告曝光未完成 */
    _13003(13003),
    /** 继续观看点击 */
    _13004(13004),
    /** 广告曝光完成 */
    _13005(13005),
    /** 外链点击 */
    _13006(13006),
    /** 广告加载完成 */
    _13008(13008),
    /** 关闭按钮点击 */
    _13009(13009),
    /** 应用开始下载 */
    _13010(13010),
    /** 应用下载完成 */
    _13011(13011),
    /** 应用安装完成 */
    _13012(13012),
    /** 广告曝光异常 */
    _13013(13013),
    /** 视频播放页点击 */
    _13014(13014),
    /** 播放结束页点击 */
    _13015(13015),
    /** 视频入口曝光 */
    _13016(13016),
    /** 视频入口点击 */
    _13017(13017),
    //Inspire END
    ;

    private int original;

    DSMt(int original) {
        this.original = original;
    }

    public int getOriginal() {
        return original;
    }

    /**
     * 根据原值返回枚举
     * @param original 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain DSMt#_OTHER _OTHER}
     */
    public static DSMt of(Integer original) {
        DSMt[] values = DSMt.values();
        for (DSMt value : values) {
            if (original == value.getOriginal()) {
                return value;
            }
        }
        return _OTHER;
    }
}
