package com.bxm.adscounter.facade;

/**
 * 激励视频对外埋点类型
 * @author kerry.jiang
 * @date 2019/6/14
 * @since 1.0.0
 */
public enum InspireMt {

    /** 不明的 */
    _OTHER(-99, -99),
    /** 接收到广告视频 */
    _1(1, 5),
    /** 开始播放视频 */
    _2(2, 6),
    /** 播放完成视频 */
    _3(3, 202),
    /** 视频播放页（结束页）点击跳转/点击下载 */
    _4(4, 7),
    /** 关闭按钮点击 */
    _5(5, 204),
    /** 应用下载完成 */
    _6(6, 206),
    /** 应用安装完成 */
    _7(7, 207),
    ;

    /**
     * 对外MT
     */
    private int original;
    /**
     * @see Mt
     */
    private int mt;

    InspireMt(int original, int mt) {
        this.original = original;
        this.mt = mt;
    }

    public int getOriginal() {
        return original;
    }

    public int getMt() {
        return mt;
    }

    /**
     * 根据原值返回枚举
     * @param original 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain InspireMt#_OTHER _OTHER}
     */
    public static InspireMt of(Integer original) {
        InspireMt[] values = InspireMt.values();
        for (InspireMt value : values) {
            if (original == value.getOriginal()) {
                return value;
            }
        }
        return _OTHER;
    }
}
