package com.bxm.adscounter.facade.model;

import com.bxm.adscounter.facade.Mt;
import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateLength;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>ADX-埋点接口参数类 </p>
 */
@Data
public class AdxTicketCountMsgDto implements Serializable{
    private static final long serialVersionUID = -537631479506482834L;
    /**
     * 模块类型modelType
     * @see Mt#getOriginal()
     */
    @ValidateNotNull
    private Integer mt;
    /**
     * 竞价id
     */
    @ValidateNotNull
    private String bidid;
    /**
     * ADX广告券ID
     */
    @ValidateNotNull
    private Long adid;
    /**
     * 广告位ID
     */
    private String tagid;
    /**
     * adx素材id
     */
    private String createid;
    /**
     * 用户IP
     */
    private String ip;
    /**
     * 操作系统
     */
    private String os;
    /**
     * User Agent
     */
    private String ua;
    /**
     * IEMI信息
     */
    private String imei;
    /**
     * IDFA信息
     */
    private String idfa;
    /**
     * 出价价格/赢价价格,加密数据,单位:分
     */
    private String win;

    /**
     * 出价价格/赢价价格,单位:分
     * 目前外部无传入值
     */
    private Integer price;

     /**
     * 请求日期时间戳
     */
    private Long time;
    /**
     * 联网方式,0:未知, 1:wifi, 2:数据网络-未知, 3:2G, 4:3G, 5:4G, 6:5G
     */
    private String nettype;
    /**
     * 设备类型
     */
    private String devm;
    /**
     * 用户id
     */
    private String uid;
    /**
     * 用户性别
     */
    private String gender;
    /**
     * 出生年份
     */
    private String yob;
    /**
     * 用户标签
     */
    private String ulab;
    /**
     * 经度
     */
    private String lon;
    /**
     * 纬度
     */
    private String lat;
    /**
     * 定位类型
     */
    private String gtype;
    /**
     * 应用id
     */
    private String appid;
    /**
     * 应用名称
     */
    private String appname;
    /**
     * 应用唯一标识
     * 安卓为包名，IOS为number ID
     */
    private String appbun;
    /**
     * 应用类型
     */
    private String appcat;
    /**
     * adx素材url
     */
    private String asseturl;

}
