/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.adscounter.integration.TicketServiceIntegration;
import com.bxm.adscounter.model.EffectEndpoint;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class JingDongIntegration {
    private static final Logger log = LoggerFactory.getLogger(JingDongIntegration.class);
    public static final String JINGDONG_KEY = "jingdong";
    private static String URL = "http://adcollect.m.jd.com/adcollect.action?unionId=350271407&subunionId=bxm1&clientType=4&client_ip=";
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private TicketServiceIntegration ticketServiceIntegration;
    @Resource
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    private LoadingCache<String, String> redisCache = CacheBuilder.newBuilder().maximumSize(10L).refreshAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) {
            return (String)JingDongIntegration.this.fetcher.hfetch(() -> "ADVERTISER:ADSHOP_SEND", key, String.class);
        }
    });

    public void send(EffectEndpoint endpoint) {
        try {
            String json = (String)this.redisCache.get((Object)JINGDONG_KEY);
            if (StringUtils.isBlank((CharSequence)json)) {
                return;
            }
            List advertisers = JSON.parseArray((String)json, BigInteger.class);
            Ticket ticket = this.ticketServiceIntegration.get(BigInteger.valueOf(endpoint.getTicketId()));
            if (CollectionUtils.isEmpty((Collection)advertisers) || !advertisers.contains(ticket.getAdvertiser())) {
                return;
            }
            String result = (String)this.restTemplate.getForObject(URL = URL + endpoint.getIp() + "&ua=" + endpoint.getApp(), String.class, new Object[0]);
            if (result == null) {
                log.warn("\u4eac\u4e1c\u6570\u636e\u4f20\u8f93\u8c03\u7528\u5931\u8d25");
                return;
            }
            Integer status = JSON.parseObject((String)result).getInteger("status");
            if (status != 1) {
                log.warn("\u4eac\u4e1c\u6570\u636e\u4f20\u8f93\u8c03\u7528\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u63a5\u53e3\u8c03\u7528\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
    }
}

