/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration.impl;

import com.bxm.adscounter.integration.TicketServiceIntegration;
import com.bxm.adscounter.model.EffectEndpoint;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adsprod.facade.ticket.BindCouponRequest;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.IllegalTicketException;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.utils.TypeHelper;
import java.math.BigInteger;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TicketServiceIntegrationImpl
implements TicketServiceIntegration {
    private static final Logger log = LoggerFactory.getLogger(TicketServiceIntegrationImpl.class);
    @Resource
    private TicketService ticketService;

    @Override
    public Ticket view(GeneralEndpoint generalEndpoint) {
        String uid = generalEndpoint.getUid();
        String ticketId = String.valueOf(generalEndpoint.getTicketId());
        String appKey = generalEndpoint.getAppKey();
        String business = generalEndpoint.getBusiness();
        String assetsId = generalEndpoint.getAssetsId();
        business = this.repairBusiness(business);
        Ticket view = this.ticketService.view(new ViewRequest(uid, TypeHelper.castToBigInteger((Object)ticketId), StringUtils.join((Object[])new String[]{appKey, business}, (char)'-'), TypeHelper.castToBigInteger((Object)assetsId)));
        return view == null ? new Ticket() : view;
    }

    @Override
    public Ticket click(GeneralEndpoint generalEndpoint) {
        String uid = generalEndpoint.getUid();
        String ticketId = String.valueOf(generalEndpoint.getTicketId());
        String appKey = generalEndpoint.getAppKey();
        String business = generalEndpoint.getBusiness();
        String assetsId = generalEndpoint.getAssetsId();
        business = this.repairBusiness(business);
        Ticket click = this.ticketService.click(ClickRequest.of((String)uid, (BigInteger)TypeHelper.castToBigInteger((Object)ticketId), (String)StringUtils.join((Object[])new String[]{appKey, business}, (char)'-'), (boolean)false, null, (BigInteger)TypeHelper.castToBigInteger((Object)assetsId)));
        return click == null ? new Ticket() : click;
    }

    @Override
    public Ticket click(EffectEndpoint effectEndpoint) {
        String uid = effectEndpoint.getUid();
        String ticketId = String.valueOf(effectEndpoint.getTicketId());
        String appKey = effectEndpoint.getAppKey();
        String business = effectEndpoint.getBusiness();
        String assetsId = effectEndpoint.getAssetsId();
        String orderId = effectEndpoint.getOrderId();
        business = this.repairBusiness(business);
        try {
            return this.ticketService.click(ClickRequest.of((String)uid, (BigInteger)TypeHelper.castToBigInteger((Object)ticketId), (String)StringUtils.join((Object[])new String[]{appKey, business}, (char)'-'), (boolean)true, (String)orderId, (BigInteger)TypeHelper.castToBigInteger((Object)assetsId)));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return new Ticket();
        }
    }

    @Override
    public boolean updateTicketStatus(BigInteger ticketId, byte status, int reason) throws IllegalTicketException {
        return this.ticketService.updateTicketStatus(ticketId, status, reason);
    }

    @Override
    public Ticket get(BigInteger ticketId) {
        return this.ticketService.get(ticketId);
    }

    private String repairBusiness(String business) {
        if (StringUtils.isBlank((CharSequence)business)) {
            return business;
        }
        return business.replace("ad-", "").replace("money-", "");
    }

    @Override
    public boolean bindCoupon(GeneralEndpoint endpoint) {
        String ticketId = String.valueOf(endpoint.getTicketId());
        BindCouponRequest request = new BindCouponRequest();
        request.setImei(endpoint.getUid());
        request.setTicket_id(TypeHelper.castToBigInteger((Object)ticketId));
        request.setPosition_id(StringUtils.join((Object[])new String[]{endpoint.getAppKey(), "-", endpoint.getBusiness()}));
        request.setUse_type(endpoint.getUseType());
        request.setCoupons_code(endpoint.getCouponsCode());
        return this.ticketService.bindCoupon(request);
    }

    @Override
    public boolean useCoupon(EffectEndpoint endpoint) {
        String ticketId = String.valueOf(endpoint.getTicketId());
        BindCouponRequest request = new BindCouponRequest();
        request.setImei(endpoint.getUid());
        request.setTicket_id(TypeHelper.castToBigInteger((Object)ticketId));
        request.setPosition_id(StringUtils.join((Object[])new String[]{endpoint.getAppKey(), "-", endpoint.getBusiness()}));
        request.setUse_type(endpoint.getUseType());
        request.setCoupons_code(endpoint.getCouponsCode());
        return this.ticketService.useCoupon(request);
    }
}

