package com.bxm.adscounter.model;

import java.io.Serializable;

import com.bxm.adscounter.facade.mt.Mt;
import com.bxm.adscounter.model.constant.Constants;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * 抽象的端点，它定义了一些通用的埋点参数。不允许直接使用。
 *
 * @author allen
 * @date 2019/3/8
 * @since 1.0.0
 */
@Data
public abstract class AbstractEndpoint implements Endpoint, Serializable {

    private static final long serialVersionUID = -4805979249918133754L;

    /**
     * 是否发送 Endpoint 给数据中心，默认：true
     */
    private boolean sendEndpointToDataCenter = true;

    /**
     * 埋点类型
     */
    private DotTypeEnum dotType;
    /**
     * 用户IP地址
     */
    private String ip;
    /**
     * appkey
     */
    private String appKey;
    /**
     * business，目前以 ad- / money- 开头，后续需要考虑删除前缀
     */
    private String business;
    /**
     * 该参数表示一个用户从进入活动到关闭，贯穿整个链路的唯一流水号
     */
    private String spm;
    /**
     * 第三方匿名设备识别号（需接第三方SDK）
     */
    //private String oaid;
    /**
     * 用户ID
     */
    private String uid;
    /**
     * 系统类型：1- 安卓、2- ios、3- web
     */
    private Integer appos;
    /**
     * 系统版本
     */
    private String apposVersion;
    /**
     * 设备型号：华为 mate 10 pro
     */
    private String devm;
    /**
     * 应用平台：1- 微信、2- 支付宝、5- 其他 原名ua
     */
    private String app;
    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * preid
     */
    private Long ticketId;
    /**
     * 广告券素材ID
     */
    private String assetsId;
    /**
     * model_type
     */
    private Integer mt;
    /**
     * 触发本次行为在屏幕上的x坐标
     */
    private String x;
    /**
     * 触发本次行为在屏幕上的y坐标
     */
    private String y;
    /**
     * 请求源。如：https://m.cudaojia.com
     */
    private String origin;
    /**
     * 来路地址
     */
    private String referrer;
    /**
     * User-Agent
     */
    private String userAgent;
    /**
     * MAC地址
     */
    private String mac;
    /**
     * 订单号，以前的bxm_id、countId
     */
    private String orderId;
    /**
     * 附加。自定义扩展<br/>
     * 格式：k:v,k:v
     */
    private String ext;

    /**
     * 广告券类型。1- 常规券、2- 备用券、3- 激励券、4- 券码类
     */
    private Byte ticketType;
    /**
     * 票券类型,0单次唯一码，1多次唯一码，2限时码，3限量码
     */
    private Integer useType;
    /**
     * 票券优惠码
     */
    private String couponsCode;
    /**
     * 人群包ID，多个以英文逗号分隔
     */
    private String tasks;
    /**
     * 人群包来源，1：个推
     */
    private String taskSouce;
    private String extJson;

    /**
     * 入口广告id（券id）
     */
    private Long entranceTicketId;
    /**
     * 入口素材id
     */
    private Long entranceAssetsId;
    /**
     * Bid id
     */
    private String bidid;
    /**
     * Outer bid id
     */
    private String obidid;
    /**
     * Adx app id
     */
    private String adxAppId;

    @Override
    public Mt getModelType() {
        return Mt.of(getMt());
    }

    public String getPositionIdForAppKeyBusiness() {
        String appKey = getAppKey();
        String business = StringUtils.replacePattern(getBusiness(),
                Constants.BSNS_AD_MONEY, StringUtils.EMPTY);
        return StringUtils.join(new Object[] { appKey, business }, Constants.SPLIT_RAIL);
    }
}
