package com.bxm.adscounter.model;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 通用的广告主方
 *
 * @author tangx
 * @date 2022/7/20 19:09
 */
@AllArgsConstructor
@Getter
public enum RtbAdvertiser {

    /**
     * 淘宝
     */
    TAOBAO("taobao", "transformType"),

    /**
     * 滴滴
     */
    DIDI("didi", "event_type"),

    /**
     * 美团
     */
    MeiTuan("meituan", "event_type"),

    /**
     * 美团优选
     */
    MeiTuanYouXuan("meituanyouxuan", "event_type"),

    /**
     * 美团ocps
     */
    MeiTuanOcps("meituanOcps", "event_type"),

    /**
     * 同程
     */
    TongCheng("tongcheng", "type"),

    /**
     * 高德
     */
    GaoDe("gaode", "event_type"),

    /**
     * 变现猫（自动回传）
     */
    BianXianMaoM("bxmm", "type"),

    /**
     * 饿了么
     */
    Eleme("eleme", "event_type"),

    /**
     * 京东
     */
    Jd("jd", "actionType"),

    /**
     * 海外统一广告主
     */
    Overseas("overseas", "conversion_type"),

    /**
     * 手机百度
     */
    ShouJiBaiDu("shoujibaidu", "event_type"),

    /**
     * 淘宝超级红包
     */
    TaobaoVegas("taobaovegas", "event_type"),

    /**
     * 百度
     */
    Sbgfjc("sbgfjc","event_type"),

    /**
     * 饿了么点击监测
     */
    Elemedjjc("elemedjjc","event_type"),

    /**
     * TalkX
     */
    TalkX("talkx", "conversion_type"),

    /**
     * 支付宝
     */
    Alipay("alipay","trackType"),

    /**
     * 汽车之家
     */
    Qczj("qczj","trackType"),

    /**
     * qihang
     */
    QiHang("qihang","transformType"),
    ;

    private String type;

    /**
     * 广告主转化类型（根据具体广告主的参数配置）
     */
    private String transferType;

    public static RtbAdvertiser getByType(String type) {
        for (RtbAdvertiser rtbAdvertiser : RtbAdvertiser.values()) {
            if (rtbAdvertiser.getType().equals(type)) {
                return rtbAdvertiser;
            }
        }
        return null;
    }
}
