package com.bxm.adscounter.model;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 通用的流量方
 * @author tangx
 * @date 2022/7/20 19:09
 */
@AllArgsConstructor
@Getter
public enum RtbMedia {

    /**
     * 多盟
     */
    DOMOB("domob"),

    /**
     * 快手
     */
    KUAISHOU("kuaishou"),

    /**
     * 广点通
     */
    GUANGDIANTONG("guangdiantong"),

    /**
     * Vivo
     */
    VIVO("vivo"),

    /**
     * 爱奇艺
     */
    IQIYI("iqiyi"),

    /**
     * 小米
     */
    XIAOMI("xiaomi"),

    /**
     * 巨量引擎
     */
    OCEANENGINE("oceanengine"),

    /**
     * 趣头条
     */
    QUTOUTIAO("qutoutiao"),

    /**
     * 华为
     */
    HUAWEI("huawei"),

    /**
     * Mintegral 海外
     */
    MINTEGRAL("Mintegral"),

    /**
     * bigo
     */
    BIGO("Bigo"),

    /**
     * wifi万能钥匙
     */
    WIFI("wifi"),

    /**
     * 小步
     */
    XIAOBU("XiaoBu"),

    /**
     * SmallStep
     */
    SMALLSTEP("SmallStep"),

    /**
     * 百度
     */
    BAIDU("baidu"),

    /**
     * hiv
     */
    HIV("HIV"),

    /**
     * 星推
     */
    XINGTUI("XingTui"),

    /**
     * MKIT
     */
    MKIT("MKIT"),

    /**
     * adwinwin
     */
    adwinwin("adwinwin"),

    /**
     * 安悦
     */
    ANYUE("AnYue"),

    /**
     * 七猫小说
     */
    QIMAOXIAOSHUO("qimaoxiaoshuo"),

    /**
     * 网易云音乐
     */
    CLOUDMUSIC("cloudmusic"),

    /**
     * 盘古
     */
    PANGU("pangu"),

    /**
     * oppo
     * https://www.teambition.com/task/6618f3ce7994eee1d1fddb43
     */
    OPPO("oppo"),
    ;

    private String type;

    public static RtbMedia getByType(String type) {
        for (RtbMedia rtbMedia : RtbMedia.values()) {
            if (rtbMedia.getType().equalsIgnoreCase(type)) {
                return rtbMedia;
            }
        }
        return null;
    }
}
