package com.bxm.adscounter.model.constant;

/**
 * 常量<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/25 10:54
 */
public interface Constants {

    /**
     * 默认用户id
     */
    String DEF_UID = "000000000000";

    /**
     * 分隔符：冒号
     */
    String SPLIT_COLON = ":";
    /**
     * 分隔符：横杆
     */
    String SPLIT_RAIL = "-";
    /**
     * 分隔符：英文逗号
     */
    String SPLIT_COMMA = ",";

    /**
     * 广告位业务代码 - ad
     */
    String BSNS_AD = "ad-";
    /**
     * 广告位业务代码 - 处理前
     */
    String BSNS_AD_MONEY = "ad-|money-";
    /**
     * 广告位业务代码 - 处理后
     */
    String BSNS_MONEY = "money-";

    /**
     * 盘古
     */
    interface PanGu {

        /**
         * APP包名
         */
        String EXT_APP_BUNDLE = "app_name";
        /**
         * adx id
         */
        String EXT_ADX_ID = "adx_id";
        /**
         * 应用分类
         */
        String EXT_APP_CAGY = "appCagy";
        /**
         * adx广告位ID(外部广告位ID)
         */
        String EXT_ADX_TAG_ID = "adx_tag_id";
        /**
         * 底价
         */
        String EXT_FLOOR = "floor";
    }

    /**
     * 监测方式
     */
    interface TrackType {
        Integer CLICK = 1;
        Integer EXPOSURE = 2;
        Integer OTHER = 3;
    }

    interface MeituanOcps {
        public static final String DIRECT = "direct";
        public static final String QUANTITY = "quantity";
    }
}
