package com.bxm.adscounter.model.msgqueue;

import java.io.Serializable;

/**
 * 发送到MQ的对象类
 */
public class MqResult implements Serializable {

	private static final long serialVersionUID = 8096521986867951937L;
	private int code;
	/**
	 * 原先发送到MQ中的统计数据（保留）
	 */
	private CountAwradmsg countAwardmsg;

	/**
	 * 发送广告组 MQ 消息
	 */
	private CountCertifiateAdshop countCertifiateAdshop;

	public static MqResult ofGeneral(CountAwradmsg countAwardmsg) {
		return new MqResult(1, countAwardmsg, null);
	}

	public static MqResult ofEffect(CountCertifiateAdshop countCertifiateAdshop) {
		return new MqResult(2, null, countCertifiateAdshop);
	}

	private MqResult(int code, CountAwradmsg countAwardmsg, CountCertifiateAdshop countCertifiateAdshop) {
		this.code = code;
		this.countAwardmsg = countAwardmsg;
		this.countCertifiateAdshop = countCertifiateAdshop;
	}

	public MqResult() {
		super();
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public CountAwradmsg getCountAwardmsg() {
		return countAwardmsg;
	}

	public void setCountAwardmsg(CountAwradmsg countAwardmsg) {
		this.countAwardmsg = countAwardmsg;
	}

	public CountCertifiateAdshop getCountCertifiateAdshop() {
		return countCertifiateAdshop;
	}

	public void setCountCertifiateAdshop(CountCertifiateAdshop countCertifiateAdshop) {
		this.countCertifiateAdshop = countCertifiateAdshop;
	}
}
