package com.bxm.adscounter.rtb.common;

/**
 * RTB 平台定义。
 *
 * @author allen
 * @date 2022-05-13
 * @since 1.0
 */
public enum Rtb {

    /**
     * 快手
     */
    Kuaishou(1),

    /**
     * 百度
     */
    Baidu(2),

    /**
     * 广点通
     */
    GuangDianTong(3),

    /**
     * 巨量引擎
     */
    JuLiangYinQing(4),

    /**
     * 爱奇艺
     */
    iQiyi(5),

    /**
     * 有道
     */
    Youdao(6),

    /**
     * UC
     */
    Uc(7),

    /**
     * 喜马拉雅
     */
    Ximalaya(8),

    /**
     * 极光
     */
    JiGuang(9),

    /**
     * 支付宝生活
     */
    AlipayLife(10),

    /**
     * 趣头条
     */
    Qtt(11),

    /**
     * 极光adx
     */
    JiGuangAdx(12),

    /**
     * 小米
     */
    XiaoMi(13),

    /**
     * Vivo
     */
    Vivo(14),

    /**
     * 美团
     */
    MeiTuan(15),
    /**
     * wifi万能钥匙
     */
    WIFI(16),
    /**
     * 微博
     */
    WeiBo(17),
    /**
     * Bigo
     */
    Bigo(18),

    /**
     * OPPO
     */
    OPPO(19),

    /**
     * sigmob Dsp
     */
    SigmobDsp(20),

    /**
     * 多盟
     */
    Domob(21),

    /**
     * mintegral
     */
    Mintegral(22),
    /**
     * adbee
     */
    Adbee(23),

    /**
     * b站
     */
    Bilibili(24),

    /**
     * 瑞狮
     */
    Ruishi(25),

    /**
     * 搜狐
     */
    SouHu(26),

    /**
     * 易效
     */
    YiXiao(27),
    /**
     * 七猫
     */
    QiMao(28),
    /**
     * 讯飞
     */
    XunFei(29),
    /**
     * 快看
     */
    KuaiKan(30),

    /**
     * sigmob 互动
     */
    SigmobInads(31),

    /**
     * 变现猫
     */
    BXM(32),

    /**
     * 360
     */
    pc360(33),
    /**
     * 优酷
     */
    YOUKU(34),

    /**
     * 凤凰新闻
     */
    IFENG(35),

    /**
     * 微博应用下载
     */
    WEIBODOWNLOAD(36),

    /**
     * 华为
     */
    HUAWEI(37),

    /**
     * 支付宝灯火小程序
     */
    ALIPAY_DH(38),

    /**
     * 梦然ssp
     */
    MENGRAN(39),


    /* -------------- 下面是针对ocpx使用 -------------- */


    /**
     * 多盟ocpx
     */
    DomobOcpx(101),

    /**
     * 小米ocpx
     */
    XiaoMiOcpx(102),

    /**
     * 华为ocpx
     */
    HuaWeiOcpx(103),

    /**
     * mintegral 海外
     */
    MintegralOverseas(104),

    /**
     * wifi万能钥匙ocpx
     */
    WifiOcpx(105),

    /**
     * 小步 海外
     */
    XiaoBu(106),

    /**
     * SmallStep 海外
     */
    SmallStep(107),

    /**
     * 百度ocpx
     */
    BaiduOcpx(108),

    /**
     * hiv 效果回传
     */
    HIV(109),

    /**
     * 星推 效果回传
     */
    XingTui(110),

    /**
     * mkit 效果回传
     */
    MKIT(111),

    adwinwin(112),

    /**
     * 安悦
     */
    AnYue(113),

    /**
     * 七猫小说
     */
    QiMaoOcpx(114),

    /**
     * 网易云音乐
     */
    CloudMusic(115),
    ;

    private final int type;

    Rtb(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }

    public static Rtb of(int type) {
        Rtb[] rtbs = values();
        for (Rtb rtb : rtbs) {
            if (rtb.getType() == type) {
                return rtb;
            }
        }
        return null;
    }
}
