package com.bxm.adscounter.rtb.common;

import com.bxm.adscounter.rtb.common.aop.ControlRtbIntegrationAspect;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;

/**
 * RTB 集成服务。
 *
 * 我们推荐使用继承{@link com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration}的实现。
 *
 * @author allen
 * @date 2022-05-13
 * @since 1.0
 * @see com.bxm.adscounter.rtb.common.aop.RtbIntegrationAspect
 * @see ControlRtbIntegrationAspect
 * @see com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration
 */
public interface RtbIntegration {

    // --------------------------------------------------------------- //
    //        不用轻易修改这里的方法定义，除非你很明确会造成什么影响。        //
    // --------------------------------------------------------------- //

    /**
     * RTB 平台
     * @return RTB
     */
    Rtb rtb();

    /**
     * 返回回传URL
     * @return URL
     */
    String getFeedbackUrl();

    /**
     * 回传转化
     * @param request 回传请求
     * @return 回传结果，如果是 {@code null} 则直接抛出 ({@link FailType#ResponseIsNull}) 异常。
     * @throws RtbIntegrationException 回传发送了异常
     */
    FeedbackResponse doFeedback(FeedbackRequest request) throws RtbIntegrationException;

    /**
     * 回传转化
     * @param request 回传请求
     * @param status 状态，主要用来判断是否走控制过滤器 {@link ControlRtbIntegrationAspect}。
     *               <li>0 {@link #doFeedback(FeedbackRequest)}</li>
     *               <li>1 智能回传</li>
     *               <li>2 oCPX回传</li>
     *               <li>9 失败重试</li>
     * @return 回传结果，如果是 {@code null} 则直接抛出 ({@link FailType#ResponseIsNull}) 异常。
     * @throws RtbIntegrationException 回传发送了异常
     */
    FeedbackResponse doFeedback(FeedbackRequest request, int status) throws RtbIntegrationException;
}
