package com.bxm.adscounter.rtb.common.aop.interceptor;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.aop.RtbFeedbackInterceptor;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import lombok.extern.slf4j.Slf4j;

import java.util.Optional;

/**
 * @author allen
 * @date 2022-05-13
 * @since 1.0
 */
@Slf4j
public class LoggerInterceptor implements RtbFeedbackInterceptor {

    @Override
    public void doRequest(RtbIntegration integration, FeedbackRequest request) {
    }

    @Override
    public void doSuccess(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        log.info("Success - [{}] - {} - {}", integration.rtb(), request.getRequestUrl(), response.getBody());
    }

    @Override
    public void doFail(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        log.info("Fail - [{}] - {} - {}", integration.rtb(), request.getRequestUrl(), response.getBody());
    }

    @Override
    public void doException(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, Throwable throwable) {
        String requestUrl = Optional.ofNullable(request)
                .map(FeedbackRequest::getRequestUrl)
                .orElse("?");
        FailType failType = null;
        if (throwable instanceof RtbIntegrationException) {
            RtbIntegrationException exception = (RtbIntegrationException) throwable;
            failType = exception.getFailType();
        }
        String fail = Optional.ofNullable(failType)
                .map(FailType::name)
                .orElse("?");
        log.error("Exception - [{}] - {} - {} - {}", integration.rtb(), fail,
                requestUrl, throwable.getMessage());
    }
}
