package com.bxm.adscounter.rtb.common.aop.interceptor;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.aop.RtbFeedbackInterceptor;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;

/**
 * @author allen
 * @date 2022-05-13
 * @since 1.0
 */
public class StatsticsMeterInterceptor implements MeterBinder, RtbFeedbackInterceptor {

    private static final String NAME = "rtb.feedback";
    private MeterRegistry registry;

    @Override
    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void doRequest(RtbIntegration integration, FeedbackRequest request) {
        registry.counter(NAME, "type", "request", "rtb", integration.rtb().name()).increment();
    }

    @Override
    public void doSuccess(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        registry.counter(NAME, "type", "success", "rtb", integration.rtb().name()).increment();
    }

    @Override
    public void doFail(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        registry.counter(NAME, "type", "fail", "rtb", integration.rtb().name()).increment();
    }

    @Override
    public void doException(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, Throwable throwable) {
        registry.counter(NAME, "type", "error", "rtb", integration.rtb().name()).increment();
    }
}
