package com.bxm.adscounter.rtb.common.autoconfigure;

import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.control.ratio.listener.*;
import com.bxm.adscounter.rtb.common.listener.RtbDeductionEventListener;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Updater;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @date 2022-10-18
 * @since 1.0
 */
public class RatioControlAutoConfiguration {

    private final Updater updater;
    private final Counter counter;

    public RatioControlAutoConfiguration(@Qualifier("rtbJedisUpdater") Updater updater,
                                         @Qualifier("rtbJedisCounter") Counter counter) {
        this.updater = updater;
        this.counter = counter;
    }

    @Bean
    public RatioClickEventListener ratioClickEventListener() {
        return new RatioClickEventListener(updater, counter);
    }

    @Bean
    public RatioConversionEventListener ratioConversionEventListener() {
        return new RatioConversionEventListener(counter);
    }

    @Bean
    public RatioFeedbackEventListener ratioFeedbackEventListener() {
        return new RatioFeedbackEventListener(counter);
    }

    @Bean
    public RatioFeedbackExceptionEventListener ratioFeedbackExceptionEventListener() {
        return new RatioFeedbackExceptionEventListener(counter);
    }

    @Bean
    public RatioPlusEventListener ratioPlusEventListener() {
        return new RatioPlusEventListener(counter);
    }

    @Bean
    public RatioOpenLogEventListener ratioOpenLogEventListener(RtbProperties properties, OpenLogClient openLogClient) {
        return new RatioOpenLogEventListener(properties, openLogClient);
    }

    @Bean
    public RatioDeductionEventListener ratioDeductionEventListener() {
        return new RatioDeductionEventListener(counter);
    }

    @Bean
    public RtbDeductionEventListener rtbDeductionEventListener(RtbProperties properties, OpenLogClient openLogClient) {
        return new RtbDeductionEventListener(properties, openLogClient);
    }

    @Bean
    public AdGroupFetchOpenLogEventListener adGroupFetchOpenLogEventListener(RtbProperties properties, OpenLogClient openLogClient) {
        return new AdGroupFetchOpenLogEventListener(properties, openLogClient);
    }

    @Bean
    public AdGroupFetchControlHandleEventListener adGroupFetchPushEventListener() {
        return new AdGroupFetchControlHandleEventListener();
    }

    @Bean
    public AdGroupFetchExceptionNotifyEventListener adGroupFetchExceptionNotifyEventListener(RtbProperties properties) {
        return new AdGroupFetchExceptionNotifyEventListener(properties);
    }
}
