package com.bxm.adscounter.rtb.common.control;

import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.mapper.SrcAdUserAccessLogMapper;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.TypeHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.JedisPool;

import java.util.List;

/**
 * @author allen
 * @date 2022-07-13
 * @since 1.0
 */
@Slf4j
public class DefaultTicketRateControlRtbIntegrationImpl extends AbstractRateControlRtbIntegration {

    public DefaultTicketRateControlRtbIntegrationImpl(JedisPool jedisPool, PositionRtbService service, EventPark eventPark, RtbIntegrationFactory rtbIntegrationFactory, SrcAdUserAccessLogMapper srcAdUserAccessLogMapper) {
            super(jedisPool, service, eventPark, rtbIntegrationFactory, srcAdUserAccessLogMapper);
    }

    @Override
    protected String createControlKey(String tagId, String adId, String adGroupId, PositionRtb.SpeedControl cfg) {
        return ControlUtils.createKey(tagId, adId, adGroupId, cfg.getConvType(), TypeHelper.castToString(cfg.getId()), cfg.getStartTime(), cfg.getEndTime());
    }

    @Override
    protected String createReferencedKey(String tagId, String adId, String adGroupId, PositionRtb.SpeedControl cfg) {
        return tagId + adGroupId + adId + cfg.getConvType();
    }

    @Override
    protected List<PositionRtb.SpeedControl> chooseControls(PositionRtb config) {
        return config.getTicketControls();
    }

    @Override
    protected ActionType getActionType(PositionRtb.SpeedControl cfg) {
        if ("11".equals(cfg.getConvType())) {
            return ActionType.TICKET_CLICK;
        } else {
            return ActionType.TICKET_CONVERSION;
        }
    }
}
