package com.bxm.adscounter.rtb.common.control.rate;

/**
 * 速率控制器。
 *
 * @author allen
 * @date 2022-07-13
 * @since 1.0
 */
public interface RateControl {

    /**
     * 开始速率控制。
     */
    void start();

    /**
     * 关闭速率控制。
     */
    void shutdown();

    /**
     * 计数 1 次。
     * @see #getCount()
     */
    void count();

    /**
     * 获取已处理的次数。
     *
     * @return 次数
     * @see #count()
     */
    long getCount();

    /**
     * 暂存数据。
     *
     * @param id 用来标记本次数据的 ID，比如：bxm_id
     */
    void push(String id);

    /**
     * 刷新。
     */
    void refresh();

    /**
     * 将删除所有历史数据。
     */
    void delete();

    /**
     * 获取控制器的配置。
     * @return 配置
     */
    RateControlConfig getConfig();
}
