package com.bxm.adscounter.rtb.common.control.ratio;

import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 广告点击日志
 *
 * @author allen
 * @date 2022-10-17
 * @since 1.0
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ClickLog {

    /**
     * 广告券ID
     */
    private String adid;
    /**
     * RTB 点击ID
     */
    private String clickId;
    /**
     * 媒体标识
     */
    private String app;
    /**
     * RTB 回传配置
     */
    private PositionRtb config;
    /**
     * 点击日志
     */
    private KeyValueMap clickKeyValueMap;
    /**
     * 是否头部券
     */
    private boolean isHeadTicket;
}
